#ifndef _SQL_SNIPPETS_VIEW_H_
#define _SQL_SNIPPETS_VIEW_H_

#include "sqlide/wb_sql_editor_snippets.h"
#include "linux_utilities/listmodel_wrapper.h"
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/comboboxtext.h>
#include "sqlide/sql_editor_fe.h"
#include "workbench/wb_context_ui.h"

class SqlSnippetsView : public Gtk::ScrolledWindow
{
  wb::WBContextUI *_wbui;
  Gtk::TreeView _tree;
  Glib::RefPtr<ListModelWrapper> _ui_model;
  DbSqlEditorSnippets *_sql_snippets_model;
  Gtk::ComboBoxText _category_combo;
  SqlEditorFE _editor;
  int _last_count;

  void activate_row(const Gtk::TreeModel::Path &path, Gtk::TreeViewColumn *column);
  bool toolbar_action(const std::string& name);
  void selected_snippet();

  void handle_context_menu_item(const std::string&, const std::vector<bec::NodeId>&);
  
  void change_category();
public:
  SqlSnippetsView(wb::WBContextUI *wbui, Glib::RefPtr<Gtk::Builder> xml);

  void refresh();
};


#endif /* _SQL_SNIPPETS_VIEW_H_ */
