﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MySQL.Utilities
{
  public partial class BusyForm : Form
  {
    public BusyForm()
    {
      InitializeComponent();
    }

    static BusyForm instance = new BusyForm();

    public delegate bool CancelDelegate();

    private CancelDelegate cancelDelegate = null;

    public static DialogResult ShowModal(String title, String text, CancelDelegate deleg)
    {
      Form mainForm = Application.OpenForms["MainForm"];
      if (mainForm != null)
        instance.Owner = mainForm;

      instance.titleLabel.Text = title;
      instance.textLabel.Text = text;

      instance.cancelDelegate = deleg;

      return instance.ShowDialog();
    }


    public static void Finished()
    {
      if (instance != null)
        instance.DialogResult = DialogResult.OK;
    }

    private void cancelButtonPicture_Click(object sender, EventArgs e)
    {
      if (cancelDelegate())
        DialogResult = DialogResult.Cancel;
    }
  }
}
