/* 
 * Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _UTIL_FUNCTIONS_H_
#define _UTIL_FUNCTIONS_H_

#include "common.h"

#if !defined(_WIN32)
  #include <iconv.h>
  #include <sys/types.h>
  #include <string.h>
  #include <errno.h>
  #include <stdio.h>

  #include <stdio.h>
  #include <sys/types.h>
  #include <unistd.h>
  #include <sys/time.h>
#else
  #include <windows.h>
#endif
#include <boost/cstdint.hpp>

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
  #define g_filename_to_utf8 g_filename_to_utf8_utf8
  #define g_filename_from_utf8 g_filename_from_utf8_utf8
  #define g_filename_from_uri g_filename_from_uri_utf8
  #define g_filename_to_uri g_filename_to_uri_utf8
#endif

#include "glib.h"

#define PCRE_STATIC
#include "pcre.h"

#ifdef _WIN32
#define _br "\r\n"
#define BASE_PATH_SEPARATOR '\\'
#define BASE_PATH_SEPARATOR_STR "\\"

#else
  #define _br "\n"
  #define BASE_PATH_SEPARATOR '/'
#define BASE_PATH_SEPARATOR_STR "/"
#endif

#define BASE_ORDPTR(value)  ((void*)(unsigned long)(value))

#ifdef __cplusplus
extern "C" {
#endif

// TODO: move Windows specific stuff to base.windows library.

/*
 * Functions
 */
BASELIBRARY_PUBLIC_FUNC char *unquote_identifier(char *identifier);
BASELIBRARY_PUBLIC_FUNC char *quote_identifier(const char *identifier, const char quote_char);
BASELIBRARY_PUBLIC_FUNC char *str_g_replace(char *str, const char *search, const char *replace);
BASELIBRARY_PUBLIC_FUNC char *str_g_subst(const char *str, const char *search, const char *replace);
BASELIBRARY_PUBLIC_FUNC char *utf8_str_trim(char *str);
BASELIBRARY_PUBLIC_FUNC char *auto_line_break(const char *txt, unsigned int width, char sep);

BASELIBRARY_PUBLIC_FUNC int g_utf8_casecollate(const char *str1, const char *str2);

BASELIBRARY_PUBLIC_FUNC char *str_toupper(char *str);
BASELIBRARY_PUBLIC_FUNC int str_is_numeric(const char *str);

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
BASELIBRARY_PUBLIC_FUNC int get_value_from_registry(HKEY root_key, const char *sub_key, const char *key,
                                                    const char *def, char *value, int target_size);
BASELIBRARY_PUBLIC_FUNC int set_value_to_registry(HKEY root_key, const char *sub_key, const char *key, const char *value);
#else
FILE *base_popen(char *const argv[], pid_t *pid_ret);
int base_pclose(FILE *f, pid_t pid);
int base_read_timeout(FILE *f, int timeout, char *result, size_t result_len);
#endif

BASELIBRARY_PUBLIC_FUNC void set_os_specific_password_functions(char*(*store_func)(const char *host,
                                                                           const char *username,
                                                                           const char *password),
                                                        char*(*retrieve_func)(const char *host,
                                                                              const char *username,
                                                                              const char *password_data));


BASELIBRARY_PUBLIC_FUNC char *get_local_os_name(void);
BASELIBRARY_PUBLIC_FUNC char *get_local_hardware_info(void);

BASELIBRARY_PUBLIC_FUNC boost::int64_t get_physical_memory_size(void);

BASELIBRARY_PUBLIC_FUNC boost::int64_t get_file_size(const char *filename); 

BASELIBRARY_PUBLIC_FUNC char *strcasestr_len(const char *haystack, int haystack_len, const char *needle);

BASELIBRARY_PUBLIC_FUNC char * get_value_from_text_ex(const char *txt, int txt_length, const char *regexpr, unsigned int substring_nr);

BASELIBRARY_PUBLIC_FUNC const char *strfindword(const char *str, const char *word);

BASELIBRARY_PUBLIC_FUNC char *subst_pcre(const char *pattern, const char *repl, 
                                 int flags, int max_matches,
                                 const char *string);

BASELIBRARY_PUBLIC_FUNC char *subst_pcre_matches(const char *src, int *matches, int matchcount, const char *repl);

BASELIBRARY_PUBLIC_FUNC int base_mkdir(const char *filename, int mode, int *error_no);
BASELIBRARY_PUBLIC_FUNC int base_chdir(const char *path);

BASELIBRARY_PUBLIC_FUNC int check_file_exists(const char *filename);
BASELIBRARY_PUBLIC_FUNC int copy_file(const char* source, const char* target);
BASELIBRARY_PUBLIC_FUNC int copy_folder(const char *source_folder, const char *target_folder);
BASELIBRARY_PUBLIC_FUNC bool html_color_to_triplet(const char* color, double *red, double *green, double *blue);

#ifdef __cplusplus
};
#endif

#endif
