/* 
 * Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "base/geometry.h"

using namespace MySQL::Geometry;

//----------------- Point --------------------------------------------------------------------------

Point::Point()
{
  x= 0;
  y= 0;
}

//--------------------------------------------------------------------------------------------------

Point::Point(double x, double y)
{
  this->x= x;
  this->y= y;
}

//----------------- Size ---------------------------------------------------------------------------

Size::Size()
{
  width= 0;
  height= 0;
}

//--------------------------------------------------------------------------------------------------

Size::Size(double w, double h)
{
  width= w;
  height= h;
}

//--------------------------------------------------------------------------------------------------

bool Size::empty()
{
  return (width == 0) || (height == 0);
}

//----------------- Rect ---------------------------------------------------------------------------

Rect::Rect()
{
  pos = Point(0, 0);
  size = Size(0, 0);
}

//--------------------------------------------------------------------------------------------------

Rect::Rect(double x, double y, double w, double h)
{
  pos = Point(x, y);
  size = Size(w, h);
}

//--------------------------------------------------------------------------------------------------

bool Rect::contains(double x, double y)
{
  return !empty() && (x >= pos.x) && (x <= pos.x + size.width) &&
    (y >= pos.y) && (y <= pos.y + size.height);
}

//--------------------------------------------------------------------------------------------------

bool Rect::contains_flipped(double x, double y)
{
  // For cairo text the top is actually the bottom (when using it for hit tests).
  return !empty() && (x >= pos.x) && (x <= pos.x + size.width) &&
    (y >= pos.y - size.height) && (y <= pos.y);
}

//--------------------------------------------------------------------------------------------------

/**
 * Inflates the rectangle by adding the given amounts to the left/top coordinate and subtracting them
 * from the right/bottom coordinate.
 */
void Rect::inflate(double horizontal, double vertical)
{
  pos.x += horizontal;
  size.width -= 2 * horizontal;
  pos.y += vertical;
  size.height -= 2 * vertical;
}

//----------------- ControlBounds ------------------------------------------------------------------

ControlBounds::ControlBounds()
{
  left = 0;
  top = 0;
  width = 0;
  height = 0;
}

//--------------------------------------------------------------------------------------------------

ControlBounds::ControlBounds(int x, int y, int w, int h)
{
  left = x;
  top = y;
  width = w;
  height = h;
}

//----------------- Padding ------------------------------------------------------------------------

Padding::Padding(int padding)
{
  left = padding;
  top = padding;
  right = padding;
  bottom = padding;
}

//--------------------------------------------------------------------------------------------------

Padding::Padding(int left, int top, int right, int bottom)
{
  this->left = left;
  this->top = top;
  this->right = right;
  this->bottom = bottom;
}

//--------------------------------------------------------------------------------------------------
