/*
 *  mdc_area_group.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/Mar/12.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#ifndef _MDC_AREA_GROUP_H_
#define _MDC_AREA_GROUP_H_

#include "mdc_group.h"

BEGIN_MDC_DECLS

class CanvasItem;

class MYSQLCANVAS_PUBLIC_FUNC AreaGroup : public Group {
public:
  AreaGroup(Layer *layer);
  virtual ~AreaGroup();

  virtual void set_selected(bool flag);

  virtual void move_item(CanvasItem *item, const MySQL::Geometry::Point &pos);
  
  virtual bool can_render_gl() { return true; }
  
  virtual void repaint(const MySQL::Geometry::Rect &clipArea, bool direct);

  void repaint_contents(const MySQL::Geometry::Rect &localClipArea, bool direct);

protected:
  bool _dragged;
  bool _drag_selects_contents;

  virtual void update_bounds();
  MySQL::Geometry::Rect constrain_rect_to_bounds(const MySQL::Geometry::Rect &rect);
  
  virtual bool on_click(CanvasItem *target, const MySQL::Geometry::Point &point, MouseButton button, EventState state);
  virtual bool on_button_press(CanvasItem *target, const MySQL::Geometry::Point &point, MouseButton button, EventState state);
  virtual bool on_button_release(CanvasItem *target, const MySQL::Geometry::Point &point, MouseButton button, EventState state);
  virtual bool on_drag(CanvasItem *target, const MySQL::Geometry::Point &point, EventState state);
};

END_MDC_DECLS


#endif
