/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _MDC_INTERACTION_LAYER_H_
#define _MDC_INTERACTION_LAYER_H_

#include "mdc_layer.h"

BEGIN_MDC_DECLS

class ItemHandle;


class MYSQLCANVAS_PUBLIC_FUNC InteractionLayer : public Layer 
{
public:
  InteractionLayer(CanvasView *view);

  virtual void repaint(const MySQL::Geometry::Rect &bounds);

  void add_handle(ItemHandle *handle);
  void remove_handle(ItemHandle *handle);
  ItemHandle *get_handle_at(const MySQL::Geometry::Point &pos);

  void set_active_area(const MySQL::Geometry::Rect &rect);
  void reset_active_area();

  bool handle_mouse_move(const MySQL::Geometry::Point &pos, EventState state);
  bool handle_mouse_button_top(MouseButton button, bool press, const MySQL::Geometry::Point &pos, EventState state);
  bool handle_mouse_button_bottom(MouseButton button, bool press, const MySQL::Geometry::Point &pos, EventState state);

  void start_selection_rectangle(const MySQL::Geometry::Point &pos, EventState state);
  void update_selection_rectangle(const MySQL::Geometry::Point &end, EventState state);
  void end_selection_rectangle(const MySQL::Geometry::Point &pos, EventState state);

  void start_dragging_rectangle(const MySQL::Geometry::Point &pos);
  void update_dragging_rectangle(const MySQL::Geometry::Point &pos);
  void draw_dragging_rectangle();
  MySQL::Geometry::Rect finish_dragging_rectangle();

  sigc::signal<void, CairoCtx*> signal_custom_repaint() { return _custom_repaint; }

protected:
  std::list<ItemHandle*> _handles;
  ItemHandle *_dragging_handle;
  MySQL::Geometry::Point _dragging_pos;

  sigc::signal<void, CairoCtx*> _custom_repaint;

  MySQL::Geometry::Rect _active_area;
  
  MySQL::Geometry::Point _selection_start;
  MySQL::Geometry::Point _selection_end;
  bool _selection_started;
  bool _selection_started_by_us;

  MySQL::Geometry::Point _dragging_rectangle_start;
  MySQL::Geometry::Point _dragging_rectangle_end;
  bool _dragging_rectangle;

  void draw_selection(const MySQL::Geometry::Rect &clip);
};

END_MDC_DECLS

#endif
