/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __MDC_MAGNET_H__
#define __MDC_MAGNET_H__

#include "mdc_common.h"

BEGIN_MDC_DECLS

class Connector;
class CanvasItem;

class MYSQLCANVAS_PUBLIC_FUNC Magnet : public sigc::trackable
{
public:
  Magnet(CanvasItem *owner);
  virtual ~Magnet();

  virtual bool allows_connection(Connector *conn) const;
  virtual bool allows_disconnection(Connector *conn) const;

  void remove_all_connectors();

  virtual bool add_connector(Connector *conn);
  virtual void remove_connector(Connector *conn);

  virtual MySQL::Geometry::Point get_position_for_connector(Connector *conn, const MySQL::Geometry::Point &srcpos) const;
  virtual MySQL::Geometry::Point get_position() const;

  virtual double constrain_angle(double angle) const { return angle; }

  void set_connection_validator(const sigc::slot<bool, Connector*> &slot);
  void set_disconnection_validator(const sigc::slot<bool, Connector*> &slot);
  
  CanvasItem *get_owner() const { return _owner; }

protected:
  CanvasItem *_owner;

  std::list<Connector*> _connectors;

  sigc::slot<bool, Connector*> _connection_slot;
  sigc::slot<bool, Connector*> _disconnection_slot;

  virtual void notify_connected();

  virtual void owner_bounds_changed(const MySQL::Geometry::Rect &obounds);
  virtual void owner_parent_bounds_changed(CanvasItem *item, const MySQL::Geometry::Rect &obounds);
};


END_MDC_DECLS

#endif

