#include "stdafx.h"
#include "test.h"
#include "mdc.h"
#include <mdc_canvas_view_image.h>

using namespace mdc;
using namespace MySQL::Geometry;

BEGIN_TEST_DATA_CLASS(canvas_view)

END_TEST_DATA_CLASS


TEST_MODULE(canvas_view, "Canvas: view");


TEST_FUNCTION(1)
{
  ImageCanvasView view(500, 400);

  // test viewport

  view.set_page_size(Size(500, 400));

  ensure_equals("viewport for size=viewport", view.get_viewport().str(), Rect(0, 0, 500, 400).str());

  view.set_zoom(2);

  ensure_equals("viewport for zoom 2", view.get_viewport().str(), Rect(0, 0, 250, 200).str());

  view.set_zoom(0.5);

  ensure_equals("viewport for zoom 0.5", view.get_viewport().str(), Rect(0, 0, 500, 400).str());
}


END_TESTS
