/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#import <Cocoa/Cocoa.h>

#import "MFView.h"
#include "mforms/view.h"

@interface MFContainerBase : NSView {
  NSInteger mTag;
  float mPadding;
  int mFreezeRelayout;
  NSColor* mBackColor;
  NSColor* mDefaultBackColor;
}

- (void)setPadding:(int)padding;
- (void)setTag:(NSInteger)tag;
- (void)subviewMinimumSizeChanged;
- (void)setFreezeRelayout:(BOOL)flag;
- (void)setBackgroundColor: (NSColor*) color;
- (void)setBackgroundImage: (NSString*) path withLayout: (mforms::ImageLayout) layout;
@end
