/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include "mforms/mforms.h"
#include "mforms/simpleform.h"

using namespace mforms;

extern GThread *_mforms_main_thread;

// The first time this method is called must be from the main thread, during 
ControlFactory *ControlFactory::get_instance()
{
  static ControlFactory *instance= 0;
  
  if (!instance)
  {
    // Do some one time initializations.
    _mforms_main_thread= g_thread_self();

    instance= new ControlFactory();
  }

  return instance;
}


ControlFactory::ControlFactory()
{
  memset(&_view_impl, 0, sizeof(_view_impl));
  memset(&_form_impl, 0, sizeof(_form_impl));
  memset(&_box_impl, 0, sizeof(_box_impl));
  memset(&_button_impl, 0, sizeof(_button_impl));
  memset(&_checkbox_impl, 0, sizeof(_checkbox_impl));
  memset(&_textentry_impl, 0, sizeof(_textentry_impl));
  memset(&_textbox_impl, 0, sizeof(_textbox_impl));
  memset(&_label_impl, 0, sizeof(_label_impl));
  memset(&_selector_impl, 0, sizeof(_selector_impl));
  memset(&_listbox_impl, 0, sizeof(_listbox_impl));
  memset(&_tabview_impl, 0, sizeof(_tabview_impl));
  memset(&_panel_impl, 0, sizeof(_panel_impl));
  memset(&_filechooser_impl, 0, sizeof(_filechooser_impl));
  memset(&_radio_impl, 0, sizeof(_radio_impl));
  memset(&_imagebox_impl, 0, sizeof(_imagebox_impl));
  memset(&_progressbar_impl, 0, sizeof(_progressbar_impl));
  memset(&_table_impl, 0, sizeof(_table_impl));
  memset(&_spanel_impl, 0, sizeof(_spanel_impl));
  memset(&_treeview_impl, 0, sizeof(_treeview_impl));
  memset(&_wizard_impl, 0, sizeof(_wizard_impl));
  memset(&_utilities_impl, 0, sizeof(_utilities_impl));
  memset(&_app_impl, 0, sizeof(_app_impl));
  memset(&_drawbox_impl, 0, sizeof(_drawbox_impl));
  memset(&_app_view_impl, 0, sizeof(_app_view_impl));
  memset(&_menu_impl, 0, sizeof(_menu_impl));
  memset(&_splitter_impl, 0, sizeof(_splitter_impl));
  memset(&_menu_item_impl, 0, sizeof(_menu_item_impl));
  memset(&_tool_bar_impl, 0, sizeof(_tool_bar_impl));
  memset(&_code_editor_impl, 0, sizeof(_code_editor_impl));
  memset(&_task_sidebar_impl, 0, sizeof(_task_sidebar_impl));
}

#ifdef _WIN32
// perform a check on the function pointer table to see if there's any NULL ptrs
#define CHECKPTRS(v) \
{\
void **ptrs= (void**)&v;\
for (size_t i= 0; i < sizeof(v)/sizeof(void*); i++)\
{\
if (ptrs[i] == 0)\
{ char buf[100]; sprintf_s(buf, "%s has NULL ptr at %i\r\n", sizeof(buf), #v, i);\
  OutputDebugStringA(buf);\
}\
}\
}
#else
// perform a check on the function pointer table to see if there's any NULL ptrs
#define CHECKPTRS(v) \
{\
void **ptrs= (void**)&v;\
for (unsigned int i= 0; i < sizeof(v)/sizeof(void*); i++)\
{\
if (ptrs[i] == 0)\
printf("%s has NULL ptr at %i\n", #v, i);\
}\
}
#endif


void ControlFactory::check_impl()
{
#ifdef DEBUG
  CHECKPTRS(_view_impl);
  CHECKPTRS(_form_impl);
  CHECKPTRS(_box_impl);
  CHECKPTRS(_button_impl);
  CHECKPTRS(_checkbox_impl);
  CHECKPTRS(_textentry_impl);
  CHECKPTRS(_textbox_impl);
  CHECKPTRS(_label_impl);
  CHECKPTRS(_selector_impl);
  CHECKPTRS(_listbox_impl);
  CHECKPTRS(_tabview_impl);
  CHECKPTRS(_panel_impl);
  CHECKPTRS(_filechooser_impl);
  CHECKPTRS(_radio_impl);
  CHECKPTRS(_imagebox_impl);
  CHECKPTRS(_progressbar_impl);
  CHECKPTRS(_table_impl);
  CHECKPTRS(_spanel_impl);
  CHECKPTRS(_treeview_impl);
  CHECKPTRS(_wizard_impl);
  CHECKPTRS(_utilities_impl);
  CHECKPTRS(_drawbox_impl);
  CHECKPTRS(_app_impl);
  CHECKPTRS(_splitter_impl);
  CHECKPTRS(_webbrowser_impl);
  CHECKPTRS(_menu_impl);
  CHECKPTRS(_menu_item_impl);
  CHECKPTRS(_tool_bar_impl);
  CHECKPTRS(_task_sidebar_impl);
#endif
}


#ifdef TEST
void do_run_test()
{
  /*
  ControlFactory *fac= ControlFactory::get_instance();

  Form *form= fac->create_form();
  form->show();
  form->set_title("hello world");

  Button *btn= fac->create_button();
  btn->set_text("Click Me");
  btn->set_size(100, 30);
  btn->set_position(50, 50);
  form->add(btn);
  btn->show();

  TextEntry *text= fac->create_textentry();
  text->set_text("changeme");
  text->set_size(200, 25);
  text->set_position(50, 100);
  form->add(text);

  Label *label= fac->create_label();
  label->set_text("Value");
  label->set_size(50, 25);
  label->set_position(0, 100);
  label->set_text_align(::mforms::MiddleRight);
  form->add(label);
  */

  SimpleForm sform("Input Data", "Create");

  sform.add_label("Please fill the following information to rename tables.", false);
  sform.add_text_entry("src", "Source Name", "");
  sform.add_text_entry("dst", "Destination Name", "");
  sform.add_text_area("code", "Code", 10, "");

  sform.show();
}
#endif
