/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "stdafx.h"
#include "mforms/simplegrid.h"
#include "mforms/mforms.h"

using namespace mforms;

//------------------------------------------------------------------------------
SimpleGrid::SimpleGrid()
           : _impl(&ControlFactory::get_instance()->_simple_grid_impl)
{
  _impl->create(this);
}

//------------------------------------------------------------------------------
int SimpleGrid::add_column(const std::string& name)
{
  return _impl->add_column(this, name);
}

//------------------------------------------------------------------------------
SimpleGridPath SimpleGrid::append_header(const std::string& group_name)
{
  return _impl->append_header(this, group_name);
}

//------------------------------------------------------------------------------
SimpleGridPath SimpleGrid::append_row(const SimpleGridPath& path)
{
  return _impl->append_row(this, path);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_str_value(const Path& rid, const int col_id, const std::string& cv, const bool editable)
{
  return _impl->set_str_value(this, rid, col_id, cv, editable);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_bool_value(const Path& rid, const int col_id, bool cv, const bool editable)
{
  return _impl->set_bool_value(this, rid, col_id, cv, editable);
}

//------------------------------------------------------------------------------
std::string SimpleGrid::get_value(const Path& rid, const int col_id, mforms::CellType* type)
{
  return _impl->get_value(this, rid, col_id, type);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_fg(const Path& rid, const int col_id, const double r, const double g, const double b)
{
  return _impl->set_fg(this, rid, col_id, r, g, b);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_bg(const Path& rid, const int col_id, const double r, const double g, const double b)
{
  return _impl->set_bg(this, rid, col_id, r, g, b);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_underline(const Path& rid, const int col_id, const bool is_on)
{
  return _impl->set_underline(this, rid, col_id, is_on);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_enum_def(const Path& rid, const int col_id, std::vector<std::string>* list)
{
  return _impl->set_enum_def(this, rid, col_id, list);
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_enum(const Path& rid, const int col_id, const std::vector<std::string> &list)
{
  return _impl->set_enum_def(this, rid, col_id, new std::vector<std::string>(list));
}

//------------------------------------------------------------------------------
bool SimpleGrid::set_enum_def_c(const Path& rid, const int col_id, const char** const list)
{
  return _impl->set_enum_def_c(this, rid, col_id, list);
}

//------------------------------------------------------------------------------
void SimpleGrid::shade(const Path& rid, const Shade shade, const int col_id)
{
  _impl->shade(this, rid, shade, col_id);
}

//------------------------------------------------------------------------------
void SimpleGrid::unshade(const Path& rid, const Shade shade, const int col_id)
{
  _impl->unshade(this, rid, shade, col_id);
}

//------------------------------------------------------------------------------
bool SimpleGrid::has_shade(const Path& rid, const int col_id, const Shade s)
{
  return _impl->has_shade(this, rid, col_id, s);
}

//------------------------------------------------------------------------------
void SimpleGrid::scroll_to_row(const Path& rid)
{
  _impl->scroll_to_row(this, rid);
}
