/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_CODEEDITOR_H_
#define _STUB_CODEEDITOR_H_


#include "mforms/button.h"

#include "stub_view.h"


namespace mforms {
namespace stub {

class CodeEditorImpl : public ViewImpl
{
 protected:
  CodeEditorImpl(::mforms::CodeEditor *self)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(CodeEditor* self)
  {
    return true;
  }

  static void __stdcall set_text(CodeEditor* self, const std::string& text)
  {
  }

  static const std::string __stdcall get_text(CodeEditor* self, bool selection_only)
  {
    return "";
  }

  static void __stdcall get_selection(CodeEditor* self, int &start, int &length)
  {
  }

  static void __stdcall set_selection(CodeEditor* self, int start, int length)
  {
  }

  static bool __stdcall get_range_of_line(CodeEditor* self, int line, int &start, int &length)
  {
    return true;
  }

  static void __stdcall set_language(CodeEditor* self, SyntaxHighlighterLanguage language)
  {
  }

  static void __stdcall set_read_only(CodeEditor* self, bool flag)
  {
  }

  static void __stdcall show_markup(CodeEditor* self, LineMarkup markup, int line)
  {
  }

  static void __stdcall remove_markup(CodeEditor* self, LineMarkup markup, int line)
  {
  }

  static int __stdcall line_count(CodeEditor* self)
  {
    return 0;
  }

  static void __stdcall set_font(CodeEditor* self, const std::string &fontDescription)
  {
  }





public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_code_editor_impl.create = &CodeEditorImpl::create;
    f->_code_editor_impl.get_range_of_line = &CodeEditorImpl::get_range_of_line;
    f->_code_editor_impl.get_selection = &CodeEditorImpl::get_selection;
    f->_code_editor_impl.get_text = &CodeEditorImpl::get_text;
    f->_code_editor_impl.get_selection = &CodeEditorImpl::get_selection;
    f->_code_editor_impl.get_text = &CodeEditorImpl::get_text;
    f->_code_editor_impl.line_count = &CodeEditorImpl::line_count;
    f->_code_editor_impl.remove_markup = &CodeEditorImpl::remove_markup;
    f->_code_editor_impl.set_font = &CodeEditorImpl::set_font;
    f->_code_editor_impl.set_language = &CodeEditorImpl::set_language;
    f->_code_editor_impl.set_read_only = &CodeEditorImpl::set_read_only;
    f->_code_editor_impl.set_selection = &CodeEditorImpl::set_selection;
    f->_code_editor_impl.set_text = &CodeEditorImpl::set_text;
    f->_code_editor_impl.show_markup = &CodeEditorImpl::show_markup;
  }
};

}
}

#endif
