/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _STUB_MENU_H_
#define _STUB_MENU_H_

#include "mforms/base.h"
#include "mforms/menu.h"
#include "stub_base.h"
#include "stub_view.h"

namespace mforms {
namespace stub
{
  class MenuImpl : public ObjectImpl
  {
  public:
    MenuImpl(Menu* self);

    static bool __stdcall create(Menu* self);
    static void __stdcall remove_item(Menu* self, int i);
    static int __stdcall add_item(Menu* self, const std::string &caption, const std::string &action);
    static int __stdcall add_separator(Menu* self);
    static int __stdcall add_submenu(Menu* self, const std::string &caption, Menu *submenu);
    static void __stdcall set_item_enabled(Menu* self, int i, bool flag);
    static void __stdcall popup_at(Menu* self, Object *control, int x, int y);
    static void __stdcall clear(Menu *self);

   public:
    static void init();
  };
};
};

#endif
