/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_SIMPLEGRID_H_
#define _STUB_SIMPLEGRID_H_


#include "mforms/button.h"

#include "stub_view.h"


namespace mforms {
namespace stub {

class SimpleGridImpl : public ViewImpl
{
 protected:
  SimpleGridImpl(::mforms::SimpleGrid *self)
    : ViewImpl(self)
  {
  }


  static bool __stdcall create(SimpleGrid*)
  {
    return true;
  }

  static int __stdcall add_column(SimpleGrid*, const std::string& name)
  {
    return 0;
  }

  static SimpleGridPath __stdcall append_header(SimpleGrid*, const std::string& gid)
  {
    SimpleGridPath dummy;
    return dummy;
  }

  static SimpleGridPath __stdcall append_row(SimpleGrid*, const SimpleGridPath& path)
  {
    SimpleGridPath dummy;
    return dummy;
  }

  static bool __stdcall set_str_value(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const std::string& cv, const bool editable)
  {
    return true;
  }

  static bool __stdcall set_bool_value(SimpleGrid*, const SimpleGridPath& rid, const int col_id, bool cv, const bool editable)
  {
    return true;
  }

  static std::string __stdcall get_value(SimpleGrid*, const SimpleGridPath& rid, const int col_id, mforms::CellType* type)
  {
    return "";
  }

  static bool __stdcall set_fg(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const double r, const double g, const double b)
  {
    return true;
  }

  static bool __stdcall set_bg(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const double r, const double g, const double b)
  {
    return true;
  }

  static bool __stdcall set_underline(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const bool is_on)
  {
    return true;
  }

  static bool __stdcall set_enum(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const std::vector<std::string>& list)
  {
    return true;
  }

  static bool __stdcall set_enum_def(SimpleGrid*, const SimpleGridPath& rid, const int col_id, std::vector<std::string>* list)
  {
    return true;
  }

  static bool __stdcall set_enum_def_c(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const char** const list)
  {
    return true;
  }

  static void __stdcall shade(SimpleGrid*, const SimpleGridPath& rid, const Shade shade, const int col_id)
  {
  }

  static void __stdcall unshade(SimpleGrid*, const SimpleGridPath& rid, const Shade shade, const int col_id)
  {
  }

  static bool __stdcall has_shade(SimpleGrid*, const SimpleGridPath& rid, const int col_id, const Shade s)
  {
    return true;
  }

  static void __stdcall scroll_to_row(SimpleGrid*, const SimpleGridPath& rid)
  {
  }



public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_simple_grid_impl.add_column= &SimpleGridImpl::add_column;
    f->_simple_grid_impl.append_header= &SimpleGridImpl::append_header;
    f->_simple_grid_impl.append_row= &SimpleGridImpl::append_row;
    f->_simple_grid_impl.create= &SimpleGridImpl::create;
    f->_simple_grid_impl.get_value= &SimpleGridImpl::get_value;
    f->_simple_grid_impl.has_shade= &SimpleGridImpl::has_shade;
    f->_simple_grid_impl.scroll_to_row= &SimpleGridImpl::scroll_to_row;
    f->_simple_grid_impl.set_bg= &SimpleGridImpl::set_bg;
    f->_simple_grid_impl.set_bool_value= &SimpleGridImpl::set_bool_value;
    f->_simple_grid_impl.set_enum= &SimpleGridImpl::set_enum;
    f->_simple_grid_impl.set_enum_def= &SimpleGridImpl::set_enum_def;
    f->_simple_grid_impl.set_enum_def_c= &SimpleGridImpl::set_enum_def_c;
    f->_simple_grid_impl.set_fg= &SimpleGridImpl::set_fg;
    f->_simple_grid_impl.set_str_value= &SimpleGridImpl::set_str_value;
    f->_simple_grid_impl.set_underline= &SimpleGridImpl::set_underline;
    f->_simple_grid_impl.shade= &SimpleGridImpl::shade;
    f->_simple_grid_impl.unshade= &SimpleGridImpl::unshade;
  }
};

}
}

#endif
