/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"
#include "wf_menu.h"

using namespace System::Windows::Forms;

using namespace MySQL::Forms;

//----------------- MenuImpl -----------------------------------------------------------------------

MenuImpl::MenuImpl(mforms::Menu *self)
  : ObjectImpl(self)
{
}

//--------------------------------------------------------------------------------------------------

MenuImpl::~MenuImpl()
{
}

//--------------------------------------------------------------------------------------------------

bool MenuImpl::create(mforms::Menu* self)
{
  MenuImpl^ menu= gcnew MenuImpl(self);
  ObjectImpl::create<ContextMenu>(self, menu);
  return true;
}

//--------------------------------------------------------------------------------------------------

ContextMenu ^MenuImpl::get(mforms::Menu *self)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  return menu->get_control<ContextMenu>();
}

//--------------------------------------------------------------------------------------------------

void MenuImpl::remove_item(mforms::Menu* self, int i)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  ContextMenu^ native_menu= menu->get_control<ContextMenu>();
  native_menu->MenuItems->RemoveAt(i);
}

//--------------------------------------------------------------------------------------------------

int MenuImpl::add_item(mforms::Menu* self, const std::string& caption, const std::string& action)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  Windows::Forms::MenuItem^ item= gcnew Windows::Forms::MenuItem(CppStringToNative(caption),
    gcnew System::EventHandler(menu, &MenuImpl::menuItemClick));
  item->Tag= CppStringToNative(action);
  ContextMenu^ native_menu= menu->get_control<ContextMenu>();
  return native_menu->MenuItems->Add(item);
}

//--------------------------------------------------------------------------------------------------

int MenuImpl::add_separator(mforms::Menu* self)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  Windows::Forms::MenuItem^ item= gcnew Windows::Forms::MenuItem("-");
  ContextMenu^ native_menu= menu->get_control<ContextMenu>();
  return native_menu->MenuItems->Add(item);
}

//--------------------------------------------------------------------------------------------------

int MenuImpl::add_submenu(mforms::Menu* self, const std::string& caption, mforms::Menu* submenu)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  MenuImpl^ child_menu= (MenuImpl^) ObjectImpl::FromUnmanaged(submenu);
  Windows::Forms::MenuItem^ item= gcnew Windows::Forms::MenuItem(CppStringToNative(caption));

  ContextMenu^ native_menu= menu->get_control<ContextMenu>();
  item->MergeMenu(child_menu->get_control<ContextMenu>());
  return native_menu->MenuItems->Add(item);
}

//--------------------------------------------------------------------------------------------------

void MenuImpl::set_item_enabled(mforms::Menu* self, int i, bool flag)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  ContextMenu^ native_menu= menu->get_control<ContextMenu>();
  native_menu->MenuItems[i]->Enabled= flag;
}

//--------------------------------------------------------------------------------------------------

void MenuImpl::popup_at(mforms::Menu* self, mforms::Object* control, int x, int y)
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);

  // We need the the .NET control for which to show the context menu.
  Control^ controller = nullptr;
  if (control != NULL)
  {
    ObjectImpl^ wrapper= ObjectImpl::FromUnmanaged(control);
    controller= wrapper->get_control<Control>();
  }
  else
  {
    // If we did not get a control passed in then we take the one under the mouse 
    // determined by the last message position. This should usually work as the context menu
    // is triggered by a right mouse button click.
    DWORD position = GetMessagePos();
    POINT point;
    point.x =  (int)(short) LOWORD(position);
    point.y = (int)(short) HIWORD(position);
    HWND window = WindowFromPoint(point);
    controller = Control::FromHandle(IntPtr(window));
  }
  if (controller != nullptr)
  {
    ContextMenu^ native_menu= menu->get_control<ContextMenu>();
    native_menu->Show(controller, System::Drawing::Point(x, y));
  }
}

//--------------------------------------------------------------------------------------------------

void MySQL::Forms::MenuImpl::clear( mforms::Menu* self )
{
  MenuImpl^ menu= (MenuImpl^) ObjectImpl::FromUnmanaged(self);
  ContextMenu^ native_menu= menu->get_control<ContextMenu>();
  native_menu->MenuItems->Clear();
}

//--------------------------------------------------------------------------------------------------

void MenuImpl::menuItemClick(Object^ sender, System::EventArgs^ e)
{
  Windows::Forms::MenuItem^ item= dynamic_cast<Windows::Forms::MenuItem^>(sender);
  if (item != nullptr)
  {
    String^ action= dynamic_cast<String^>(item->Tag);
    if (action != nullptr)
    {
      mforms::Menu* menu= ObjectImpl::get_backend_control<mforms::Menu>(item->Parent);
      if (menu != NULL)
        menu->handle_action(NativeToCppString(action));
    }
  }
}

//--------------------------------------------------------------------------------------------------
