#ifndef _TEST_IMPORT_HELPERS_H_
#define _TEST_IMPORT_HELPERS_H_

// contains declarations of some functions that you might want to have
// when working with the database reveng module in tests
// function definitions are in 
// mysql-workbench-pro\library\grt\unit-tests\diff\grtdiff_alter_test.cpp

class sql::Connection;
class grt::GRT;
class db_mysql_Catalog;
class bec::GRTManager;
class sql::Statement;

void populate_grt(grt::GRT *grt, const char *rdbms_info_path);
std::auto_ptr<sql::Connection> create_connection_for_import(grt::GRT *grt);
db_mysql_CatalogRef db_rev_eng_schema(bec::GRTManager *grtm, const std::list<std::string>& schema_names);
db_mysql_CatalogRef create_empty_catalog_for_import(grt::GRT *grt);

// execute a script stmt-by-stmt, via a predefined call-back
void execute_script(sql::Statement *stmt, const std::string& script);

#endif // _TEST_IMPORT_HELPERS_H_