
/*!
 Copyright 2009 Sun Microsystems, Inc.
 
 @author
 jak
 
 @class
 MacTableEditorIndexColumnsInformationSource
 
 @abstract
 The purpose of this class is to insulate the C++ data structures needed by the MySQL Table Editor.
 
 @ingroup
 MySQL Table Editor
 */



#import "MacTableEditorIndexColumnsInformationSource.h"

#include "mysql_table_editor.h"



@implementation MacTableEditorIndexColumnsInformationSource



- (BOOL) rowEnabled: (NSInteger) rowIndex;
{
  NSAssert(mBackEnd != nil, @"The mBackEnd must not be nil.");
  
  const ::bec::NodeId& node = mBackEnd->get_indexes()->get_columns()->get_node(rowIndex);
  BOOL yn = (mBackEnd->get_indexes()->get_columns()->get_column_enabled(node) ? YES : NO);
  
  return yn;
}



- (void) setRow: (NSInteger) indexRowIndex
        enabled: (BOOL) yn;
{
  NSAssert(mBackEnd != nil, @"The mBackEnd must not be nil.");
  
  bec::IndexColumnsListBE *index_columns_be(mBackEnd->get_indexes()->get_columns());
  const ::bec::NodeId& node = mBackEnd->get_indexes()->get_node(indexRowIndex);
  index_columns_be->set_column_enabled(node, ( yn ? true : false ) );
}



- (id) initWithListModel: (bec::ListModel*) model
            tableBackEnd: (MySQLTableEditorBE*) tableBackend;
{
  self = [self initWithListModel: model];
  
  if (self != nil) {
    mBackEnd = tableBackend;
  }
  
  return self;
}



@end


