#ifndef _SCHEMA_SELECT_FORM_INCLUDED_
#define _SCHEMA_SELECT_FORM_INCLUDED_

#include "grtui/gui_plugin_base.h"
#include <mforms/mforms.h>

class SchemaSelectionForm : public GUIPluginBase, public mforms::Form
{
public:
    SchemaSelectionForm(grt::Module *module,grt::ListRef<db_Schema> schemas, db_SchemaRef default_schema):
      GUIPluginBase(module), Form(NULL, mforms::FormResizable), _box(false), _main_box(false), _button_box(true),
          _spacer_box(true), _schema_list(false), _schemas(schemas),_list_panel(::mforms::TitledBoxPanel)
    {
        set_title(_("Select Destination Dchema"));
        _list_panel.set_title("Schemas");
        _main_box.set_spacing(8);
        _main_box.set_padding(8);
        _button_box.add(&_ok_button, true, true);
        _button_box.add(&_cancel_button, true, true);
        _cancel_button.set_text(_("Cancel"));
        _ok_button.set_text(_("Select"));
        _schema_list.set_size(200, -1);
        _schema_list.set_heading("Schemas");
        for(size_t sz= _schemas.count(), i= 0; i < sz; i++)
        {
            _schema_list.add_item(_schemas[i]->name());
            if (default_schema->name() == _schemas[i]->name())
            {
                _schema_list.set_selected(i);            
            };
        };
        if (_schema_list.get_selected_index() < 0)
        {
            _schema_list.add_item("Add new schema");
            _schema_list.set_selected(_schemas.count());
        };
        _list_panel.add(&_schema_list);
        _main_box.add(&_list_panel,true,true);
        _box.add(&_main_box,true,true);
        _spacer_box.add(&_spacer_label, true, true);
        _spacer_box.add(&_button_box, false, true);
       _button_box.set_spacing(8);
       _button_box.set_padding(8);
       _button_box.set_homogeneous(true);

        _box.add_end(&_spacer_box, false, true);
        set_content(&_box);
    };

    db_SchemaRef get_selection()
    {
        if (_schema_list.get_selected_index() == _schemas.count())
            return db_SchemaRef();
        return _schemas[_schema_list.get_selected_index()];
    };

    bool run()
    {
        center();
        int x;
        x= run_modal(&_ok_button, &_cancel_button);
        mforms::View::show(false);
        return x > 0;
    }
protected:
    mforms::Box _box;
    mforms::Box _main_box;
    mforms::Panel _list_panel;
    mforms::Box _button_box;
    mforms::Box _spacer_box;
    mforms::Label _spacer_label;
    mforms::Button _cancel_button;
    mforms::Button _ok_button;
    mforms::ListBox _schema_list;
    grt::ListRef<db_Schema> _schemas;
};

#endif //#ifndef _SCHEMA_SELECT_FORM_INCLUDED_