#include "stdafx.h"

#include "db_sql_editor_log_be.h"
#include "sqlide/recordset_data_storage.h"
#include "base/string_utilities.h"
#include <boost/foreach.hpp>


using namespace bec;
using namespace grt;


DbSqlEditorLog::DbSqlEditorLog(GRTManager *grtm)
:
VarGridModel(grtm)
{
  reset();
}


void DbSqlEditorLog::reset()
{
  VarGridModel::reset();

  _readonly= true;

  add_column("", int()); // msg type (icon)
  add_column("", int()); // sequence no.
  add_column("Time", std::string());
  add_column("Action", std::string());
  add_column("Message", std::string());
  add_column("Duration / Fetch", std::string());

  boost::shared_ptr<sqlite::connection> data_swap_db= this->data_swap_db();
  Recordset_data_storage::create_data_swap_tables(data_swap_db.get(), _column_names, _column_types);

  refresh_ui();
}


class MsgTypeIcons
{
public:
  MsgTypeIcons()
  {
    IconManager *icon_man= IconManager::get_instance();
    _error_icon= icon_man->get_icon_id("mini_error.png");
    _warning_icon= icon_man->get_icon_id("mini_warning.png");
    _info_icon= icon_man->get_icon_id("mini_notice.png");
  }
private:
  IconId _error_icon;
  IconId _warning_icon;
  IconId _info_icon;
public:
  IconId icon(int msg_type)
  {
    switch (msg_type)
    {
    case grt::ErrorMsg: return _error_icon;
    case grt::WarningMsg: return _warning_icon;
    default: return _info_icon;
    }
  }
};
IconId DbSqlEditorLog::get_field_icon(const NodeId &node, int column, IconSize size)
{
  IconId icon= 0;

  static MsgTypeIcons msg_type_icons;
  switch (column)
  {
  case 0:
    Cell cell;
    if (get_cell(cell, node, column, false))
    {
      int msg_type= boost::get<int>(*cell);
      icon= msg_type_icons.icon(msg_type);
    }
    break;
  }

  return icon;
}


RowId DbSqlEditorLog::add_message(int msg_type, const std::string &context, const std::string &msg, const std::string &duration)
{
  if (msg.empty())
    return -1;

  int new_row;
  {
    GStaticRecMutexLock data_mutex(_data_mutex);

    _data.reserve(_data.size() + _column_count);

    try
    {
      _data.push_back(msg_type);
      _data.push_back((int)_row_count+1);
      _data.push_back(current_time());
      _data.push_back(base::strip_text(context));
      _data.push_back(msg);
      _data.push_back(duration);
    }
    catch(...)
    {
      _data.resize(_row_count * _column_count);
      throw;
    }

    new_row= _row_count;
    ++_row_count;
    ++_data_frame_end;
  }

  // for optimization purposes class user has to decide when to refresh
  //refresh_ui();

  return new_row;
}


void DbSqlEditorLog::set_message(RowId row, int msg_type, const std::string &context, const std::string &msg, const std::string &duration)
{
  GStaticRecMutexLock data_mutex(_data_mutex);

  RowId cell_index= row * _column_count;
  if (cell_index > _data.size())
    return;
  Data::iterator cell= _data.begin() + cell_index;

  *cell++= msg_type;
  ++cell; //*cell++= (int)row+1;
  ++cell; //*cell++= current_time();
  *cell++= base::strip_text(context);
  *cell++= msg;
  *cell++= duration;

  // for optimization purposes class user has to decide when to refresh
  //refresh_ui();
}
