/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "ModelViewForm.h"

using namespace MySQL::Grt;
using namespace MySQL::Forms;
using namespace wb;
using namespace MySQL::GUI::Mdc;

namespace MySQL {
namespace Workbench {
  
//--------------------------------------------------------------------------------------------------

ModelViewForm::ModelViewForm(ModelDiagramForm *inn)
  : UIForm(inn), layer_tree(nullptr)
{
}

//--------------------------------------------------------------------------------------------------

ModelViewForm::~ModelViewForm()
{
  //delete mini_view;
}

//--------------------------------------------------------------------------------------------------

ModelDiagramForm* ModelViewForm::get_unmanaged_object()
{
  return (ModelDiagramForm*) inner;
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::OnMouseMove(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
{
  get_unmanaged_object()->handle_mouse_move(X, Y, BaseWindowsCanvasView::getEventState(keystate, buttons));
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::OnMouseDown(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
{
  mdc::MouseButton butt= mdc::ButtonLeft;
  switch(e->Button)
  {
  case MouseButtons::Left:
    butt= mdc::ButtonLeft;
    break;

  case MouseButtons::Middle:
    butt= mdc::ButtonMiddle;
    break;

  case MouseButtons::Right:
    butt= mdc::ButtonRight;
    break;
  }
  get_unmanaged_object()->handle_mouse_button(butt, true, X, Y, 
    BaseWindowsCanvasView::getEventState(keystate, buttons));
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::OnMouseUp(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
{
  mdc::MouseButton butt= mdc::ButtonLeft;
  switch(e->Button)
  {
  case MouseButtons::Left:
    butt= mdc::ButtonLeft;
    break;

  case MouseButtons::Middle:
    butt= mdc::ButtonMiddle;
    break;

  case MouseButtons::Right:
    butt= mdc::ButtonRight;
    break;
  }
  get_unmanaged_object()->handle_mouse_button(butt, false, X, Y,
    BaseWindowsCanvasView::getEventState(keystate, buttons));
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::OnMouseDoubleClick(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
{
  mdc::MouseButton butt= mdc::ButtonLeft;
  switch(e->Button)
  {
  case MouseButtons::Left:
    butt= mdc::ButtonLeft;
    break;

  case MouseButtons::Middle:
    butt= mdc::ButtonMiddle;
    break;

  case MouseButtons::Right:
    butt= mdc::ButtonRight;
    break;
  }
  get_unmanaged_object()->handle_mouse_double_click(butt, X, Y,
    BaseWindowsCanvasView::getEventState(keystate, buttons));
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::OnKeyDown(KeyEventArgs^ e, Keys keystate)
{
  if (get_unmanaged_object()->handle_key(BaseWindowsCanvasView::getKeyInfo(e), true, 
    BaseWindowsCanvasView::getEventState(keystate, MouseButtons::None)))
  {
    // If the keyboard input has been handled then tell the caller not to process this any further.
    e->SuppressKeyPress= true;
  }
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::OnKeyUp(KeyEventArgs^ e, Keys keystate)
{
  get_unmanaged_object()->handle_key(BaseWindowsCanvasView::getKeyInfo(e), false, 
    BaseWindowsCanvasView::getEventState(keystate, MouseButtons::None));
}

//--------------------------------------------------------------------------------------------------

String^ ModelViewForm::get_tool_cursor()
{
  return CppStringToNative(get_unmanaged_object()->get_cursor());
}

//--------------------------------------------------------------------------------------------------

bool ModelViewForm::accepts_drop(int x, int y, String^ type, List<GrtValue^>^ objects)
{
  std::list<GrtObjectRef> cobjects;

  List<GrtValue^>::Enumerator^ e= objects->GetEnumerator();
  while (e->MoveNext())
  {
    if (e->Current->is_object_instance_of("GrtObject"))
      cobjects.push_back(GrtObjectRef::cast_from(e->Current->get_unmanaged_object()));
    else
      return false;
  }

  return get_unmanaged_object()->accepts_drop(x, y, NativeToCppString(type), cobjects);
}

//--------------------------------------------------------------------------------------------------

bool ModelViewForm::accepts_drop(int x, int y, String^ type, String^ text)
{
  return get_unmanaged_object()->accepts_drop(x, y, NativeToCppString(type), NativeToCppString(text));
}

//--------------------------------------------------------------------------------------------------

bool ModelViewForm::perform_drop(int x, int y, String^ type, List<GrtValue^>^ objects)
{
  std::list<GrtObjectRef> cobjects;

  List<GrtValue^>::Enumerator^ e= objects->GetEnumerator();
  while (e->MoveNext())
  {
    if (e->Current->is_object_instance_of("GrtObject"))
      cobjects.push_back(GrtObjectRef::cast_from(e->Current->get_unmanaged_object()));
    else
      return false;
  }

  return get_unmanaged_object()->perform_drop(x, y, NativeToCppString(type), cobjects);
}

//--------------------------------------------------------------------------------------------------

bool ModelViewForm::perform_drop(int x, int y, String^ type, String^ text)
{
  return get_unmanaged_object()->perform_drop(x, y, NativeToCppString(type), NativeToCppString(text));
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::set_closed(bool flag)
{
  if (get_unmanaged_object())
    get_unmanaged_object()->set_closed(flag);
}

//--------------------------------------------------------------------------------------------------

bool ModelViewForm::is_closed()
{
  if (get_unmanaged_object())
    return get_unmanaged_object()->is_closed();
  return false;
}

//--------------------------------------------------------------------------------------------------

GrtValueTree^ ModelViewForm::get_layer_tree()
{
  if (layer_tree == nullptr)
    layer_tree= gcnew GrtValueTree(get_unmanaged_object()->get_layer_tree());

  return layer_tree;
} 

//--------------------------------------------------------------------------------------------------

void ModelViewForm::setup_mini_view(BaseWindowsCanvasView^ view)
{
  mini_view= view;
  get_unmanaged_object()->setup_mini_view(mini_view->get_unmanaged_object());
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::update_mini_view_size(int w, int h)
{
  if (get_unmanaged_object() != NULL)
    get_unmanaged_object()->update_mini_view_size(w, h);
}

//--------------------------------------------------------------------------------------------------

double ModelViewForm::get_zoom()
{
  if (get_unmanaged_object() != NULL)
    return get_unmanaged_object()->get_zoom();

  return 1;
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::set_zoom(double zoom)
{
  if (get_unmanaged_object() != NULL)
    get_unmanaged_object()->set_zoom(zoom);
}

//--------------------------------------------------------------------------------------------------

String^ ModelViewForm::get_title()
{
  return CppStringToNative(get_unmanaged_object()->get_title());
}

//--------------------------------------------------------------------------------------------------

ToolStrip^ ModelViewForm::get_tools_toolbar()
{
  mforms::ToolBar* toolbar = get_unmanaged_object()->get_tools_toolbar();
  if (toolbar == NULL)
    return nullptr;

  // Weird compiler behavior ahead. We need a cast to mforms::Object* here as the compiler
  // complaines about not being able to convert from mforms::ToolBar to mforms::Object, even though
  // mforms::ToolBar is derived from mforms::Object. Very weird indeed.
  // Note: very similar code compiles fine in Wb.cpp.
  ToolBarImpl^ toolbar_impl = (ToolBarImpl^) ViewImpl::FromUnmanaged((mforms::Object*) toolbar);

  return dynamic_cast<ToolStrip^>(toolbar_impl->get_object());
}

//--------------------------------------------------------------------------------------------------

ToolStrip^ ModelViewForm::get_options_toolbar()
{
  mforms::ToolBar* toolbar = get_unmanaged_object()->get_options_toolbar();
  if (toolbar == NULL)
    return nullptr;

  ToolBarImpl^ toolbar_impl = (ToolBarImpl^) ViewImpl::FromUnmanaged((mforms::Object*) toolbar);

  return dynamic_cast<ToolStrip^>(toolbar_impl->get_object());
}

//--------------------------------------------------------------------------------------------------

void ModelViewForm::update_options_toolbar()
{
  get_unmanaged_object()->update_options_toolbar();
}

//--------------------------------------------------------------------------------------------------

} // namespace Workbench
} // namespace MySQL
