#ifndef __GRID_VIEW_H__
#define __GRID_VIEW_H__


#include "sqlide/grid_view_model.h"


class GridView : public Gtk::TreeView
{
public:
  static GridView * create(bec::GridModel::Ref model);
  ~GridView();
protected:
  GridView(bec::GridModel::Ref model);
private:
  virtual void init();

public:
  void model(bec::GridModel::Ref value);
private:
  bec::GridModel::Ref _model;
  GridViewModel::Ref _view_model;

public:
  int refresh(bool reset_columns);

  bec::NodeId current_cell(int &row, int &col);
  bec::NodeId current_node();
  int current_row();

  void delete_selected_rows();
public:
  sigc::signal<void, const Glib::ustring&, const Glib::ustring&> signal_cell_edited() { return _signal_cell_edited; }
  sigc::slot<void, const Glib::ustring&, const Glib::ustring&> slot_cell_edited() { return _signal_cell_edited.make_slot(); }
  sigc::signal<void> signal_row_count_changed() { return _signal_row_count_changed; }
private:
  sigc::signal<void, const Glib::ustring&, const Glib::ustring&> _signal_cell_edited;
  sigc::signal<void> _signal_row_count_changed;

protected:
  virtual bool on_key_press_event(GdkEventKey *event);

public:
  void on_column_header_clicked(Gtk::TreeViewColumn *column, int column_index);
  sigc::signal<void, int, int, bool> signal_sort_by_column;
  void sort_by_column(int column_index, int sort_direction, bool retaining);
protected:
  void reset_sorted_columns();

private:
  void on_cell_edited(const Glib::ustring &path_string, const Glib::ustring &new_text);

public:
  typedef std::map<int, bec::NodeId> SelectedNodes;
  void get_selected_nodes(SelectedNodes &nodes);
private:
  void add_node_for_path(const Gtk::TreeModel::Path &path, SelectedNodes &rows);

public:
  int row_count() const;
private:
  int _row_count;
  void sync_row_count();

public:
  void row_numbers_visible(bool value) { _view_model->row_numbers_visible(value); }
};


#endif // __GRID_VIEW_H__
