//
//  WBMiniToolbar.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 5/May/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class WBMiniToolbar;

@interface NSObject (WBMiniToolbarDelegate)

- (void)miniToolbar:(WBMiniToolbar*)sender
       popupChanged:(NSString*)name
             option:(NSString*)option
              value:(NSString*)value;

@end


@interface WBMiniToolbar : NSView {
  id mDelegate;
  NSMutableArray *mOptionInfoList;
}

- (void)tile;

- (void)removeAllItems;

- (void)setDelegate:(id)delegate;

- (NSButton*)addButtonWithTitle:(NSString*)title
                         target:(id)target
                         action:(SEL)action
                            tag:(int)tag;

- (NSButton*)addButtonWithIcon:(NSImage*)icon
                        target:(id)target
                        action:(SEL)action
                           tag:(int)tag;

- (NSTextField*)addLabelWithTitle:(NSString*)title;

- (void)addSeparator;

- (void)addExpandingSpace;

- (NSPopUpButton*)addSelectionPopUpWithItems:(NSArray*)items
                              name: (NSString*)name
                            option: (NSString*)option
                      defaultValue: (NSString*)defaultValue;

- (NSPopUpButton*)addSelectionPopUpWithItems:(NSArray*)items
                            target:(id)target
                            action:(SEL)action
                      defaultValue: (NSString*)defaultValue;

- (void)addSelectionPopUpWithColors:(NSArray*)colors
                               name: (NSString*)name
                             option: (NSString*)option
                       defaultValue: (NSString*)defaultValue;


@end
