/* 
 * Copyright (c) 2010, 2011 Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import "MScintillaView.h"
#include "MSQLEditorController.h"
#import "MCPPUtilities.h"
#import "NSMenu_extras.h"

@implementation MScintillaView


- (void)setEditorBackEnd:(const Sql_editor::Ref&)be
{
  mBackEnd= be;
}


- (NSMenu *)menuForEvent:(NSEvent *)theEvent
{
  if (mBackEnd)
  {      
    bec::MenuItemList items= mBackEnd->get_context_menu();
    
    if (!items.empty())
    {      
      for (bec::MenuItemList::iterator iter= items.begin(); iter != items.end(); ++iter)
      {        
        bool enabled= iter->enabled;
        if (iter->name == "undo")
          enabled= [[self content] canUndo];
        else if (iter->name == "redo")
          enabled= [[self content] canRedo];
        else if (iter->name == "cut")
          enabled= [[self content] selectedRange].length > 0;
        else if (iter->name == "copy")
          enabled= [[self content] selectedRange].length > 0;
        else if (iter->name == "paste")
        {
          NSArray* supportedTypes = [NSArray arrayWithObjects: NSStringPboardType, nil];
          NSString *bestType = [[NSPasteboard generalPasteboard] availableTypeFromArray: supportedTypes];
          if (bestType)
            enabled= true;
          else
            enabled= false;
        }
        else
          if (iter->name == "toggle_wrap_lines")
          {
            int wrap_mode = [self getGeneralProperty: SCI_GETWRAPMODE]; // None=0, Word=1, Char=2
            iter->checked = (wrap_mode == 1);
          }
        iter->enabled= enabled;
      }

      return [NSMenu menuFromMenuItems:items
                                action:@selector(activateMenuItem:)
                                target:self];
    }
  }
  return [super menuForEvent: theEvent];
}



- (void)activateMenuItem:(id)sender
{
  if (mBackEnd && [sender representedObject])
  {
    std::string action([[sender representedObject] UTF8String]);
    
    if (action == "undo")
    {
      [[self content] performSelector:@selector(undo:) withObject:nil];
    }
    else if (action == "redo")
    {
      [[self content] performSelector:@selector(redo:) withObject:nil];
    }
    else if (action == "cut")
    {
      [[self content] performSelector:@selector(cut:) withObject:nil];
    }
    else if (action == "copy")
    {
      [[self content] performSelector:@selector(copy:) withObject:nil];
    }
    else if (action == "paste")
    {
      [[self content] performSelector:@selector(paste:) withObject:nil];
    }
    else if (action == "delete")
    {
      [[self content] deleteBackward:nil];
    }
    else if (action == "select_all")
    {
      [[self content] selectAll:nil];
    }
    else
      if (action == "toggle_wrap_lines")
      {
        int wrap_mode = [self getGeneralProperty: SCI_GETWRAPMODE]; // None=0, Word=1, Char=2
        if (wrap_mode == 1)
          [self setGeneralProperty: SCI_SETWRAPMODE value: 0];
        else
          [self setGeneralProperty: SCI_SETWRAPMODE value: 1];
      }
      else
      {
        try
        {
          mBackEnd->activate_context_menu_item(action); 
        }
        catch (const std::exception &exc)
        {
          NSRunAlertPanel(@"Error", @"Could not execute plugin: %s", @"OK", nil, nil,
                          exc.what());
        }
      }
  }
}


@end
