/* 
 * Copyright © 2010, Oracle and/or its affiliates. All rights reserved.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#import "WBModelOverviewPanel.h"
#import "WBOverviewPanel.h"
#import "WBModelSidebarController.h"
#import "WBObjectDescriptionController.h"
#import "GRTListDataSource.h"
#import "GRTTreeDataSource.h"
#import "WBTabView.h"
#include "wb_overview_physical.h"

@implementation WBModelOverviewPanel

- (void)setupWithWBContextUI:(wb::WBContextUI*)wbui
{
  _wbui= wbui;
  
  [NSBundle loadNibNamed: @"WBModelOverview" owner: self];
  [(id)editorTabView createDragger];  

  [overview setupWithOverviewBE: wbui->get_physical_overview()];
  [sidebarController setupWithWBContextUI: wbui];
  
  [descriptionController setWBContext: wbui];

  [topView setDividerThickness: 3];
  
  [overview rebuildAll];

  [sidebarController refresh];

  sidebarHidden = NO;
  sidebarAtRight = NO;
  [self setRightSidebar: wbui->get_wb()->get_wb_options().get_int("Sidebar:RightAligned", 0)];
  lastSidebarWidth = [sidebar frame].size.width;
}


- (void)dealloc
{
  [[sidebarController userTypeDS] release];
  [[sidebarController historyDS] release];
  [[sidebarController catalogDS] release];
  [sidebarController invalidate];
  
  [topView release];
  [sidebarController release];
  [descriptionController release];
  [mainSplitViewDelegate release];

  [super dealloc];
}


- (NSString*)identifier
{
  return [overview identifier];
}


- (WBOverviewPanel*)overview
{
  return overview;
}


- (NSView*)topView
{
  return topView;
}


- (NSString*)title
{  
  return [overview title];
}


- (bec::UIForm*)formBE
{
  return [overview formBE];
}

- (void)didActivate
{
  [sidebarController refresh];
}

- (BOOL)willClose
{
  return [overview willClose];
}

- (void)selectionChanged
{
  [descriptionController updateForForm: [self formBE]];
}


- (WBModelSidebarController*)sidebarController
{
  return sidebarController;
}

//--------------------------------------------------------------------------------------------------

- (void)splitView:(NSSplitView*)sender resizeSubviewsWithOldSize:(NSSize)oldSize
{
  NSView *left = [[sender subviews] objectAtIndex: 0];
  NSView *right = [[sender subviews] objectAtIndex: 1];
  NSSize size = [sender frame].size;
  NSRect rect;
 
  if (sidebarAtRight)
  {
    rect = [left frame];
    rect.origin.x = 0;
    rect.size.height = size.height;
    rect.size.width = size.width - [sender dividerThickness] - NSWidth([right frame]);
    [left setFrame: rect];    
    
    rect.origin.y = [right frame].origin.y;
    rect.origin.x = NSMaxX([left frame]) + [sender dividerThickness];
    rect.size.height = size.height;
    rect.size.width = [right frame].size.width;
    [right setFrame: rect];    
  }
  else
  {
    rect = [left frame];
    rect.size.height = size.height;
    [left setFrame: rect];
    
    rect.origin.y = [right frame].origin.y;
    rect.origin.x = NSMaxX([left frame]) + [sender dividerThickness];
    rect.size.width = size.width - [sender dividerThickness] - rect.size.width;
    rect.size.height = size.height;
    [right setFrame: rect];
  }
}

//--------------------------------------------------------------------------------------------------

- (void)setRightSidebar:(BOOL)flag
{
  sidebarAtRight = flag;
  
  id view1 = [[topView subviews] objectAtIndex: 0];
  id view2 = [[topView subviews] objectAtIndex: 1];
  
  if (sidebarAtRight)
  {
    if (view2 != sidebar)
    {
      [[view1 retain] autorelease];
      [view1 removeFromSuperview];
      [topView addSubview: view1];
    }    
  }
  else
  {
    if (view1 != sidebar)
    {
      [[view1 retain] autorelease];
      [view1 removeFromSuperview];
      [topView addSubview: view1];
    }
  }
}

//--------------------------------------------------------------------------------------------------

/**
 * Executes commands sent by the main form that should be handled here.
 */
- (void) performCommand: (const std::string) command
{
  if (command == "wb.sidebarHide") // Actually means toggle.
  {
    sidebarHidden = !sidebarHidden;
    if (!sidebarHidden)
    {
      if (sidebarAtRight)
        [topView setPosition: NSWidth([topView frame])-lastSidebarWidth ofDividerAtIndex: 0];
      else
        [topView setPosition: lastSidebarWidth ofDividerAtIndex: 0];
    }
    else
    {
      lastSidebarWidth = [sidebar frame].size.width;
      if (sidebarAtRight)
        [topView setPosition: NSWidth([topView frame]) ofDividerAtIndex: 0];
      else
        [topView setPosition: 0 ofDividerAtIndex: 0];
    }
  }
}

//--------------------------------------------------------------------------------------------------

@end
