/* 
 * Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#import "WBSQLQueryPanel.h"

#import "WBMainController.h"
#import "WBMainWindow.h"
#import "MResultsetViewer.h"

#include "workbench/wb_context_ui.h"

#import "WBSQLQueryUI.h"


static WBSQLQueryPanel *getQueryPanel(wb::WBContextUI *wbui)
{
  bec::UIForm *form= wbui->get_active_main_form();
  if (form)
  {
    id panel= (id)form->get_frontend_data();
    if (panel)
    {
      if ([panel isKindOfClass: [WBSQLQueryPanel class]])
        return (WBSQLQueryPanel*)panel;
    }
  }
  return nil;
}

static void call_execute(wb::WBContextUI *wbui)
{
  [getQueryPanel(wbui) executeQuery:nil currentStatementOnly:false];
}

static bool validate_query_panel_active(wb::WBContextUI *wbui)
{
  return getQueryPanel(wbui) != nil;
}


static void call_execute_current_statement(wb::WBContextUI *wbui)
{
  [getQueryPanel(wbui) executeQuery:nil currentStatementOnly:true];
}

static bool validate_execute_current_statement(wb::WBContextUI *wbui)
{
  return getQueryPanel(wbui) != nil;
}


static void call_save_edits(wb::WBContextUI *wbui)
{
  [[getQueryPanel(wbui) selectedResultset] saveEdits: nil];
}

static bool validate_save_edits(wb::WBContextUI *wbui)
{
  return [[getQueryPanel(wbui) selectedResultset] hasPendingChanges];
}


static void call_discard_edits(wb::WBContextUI *wbui)
{
  [[getQueryPanel(wbui) selectedResultset] discardEdits:nil];  
}

static bool validate_discard_edits(wb::WBContextUI *wbui)
{
  return [[getQueryPanel(wbui) selectedResultset] hasPendingChanges];
}


static WBBasePanel *createQueryPanel(WBMainWindow *mainwin, boost::shared_ptr<bec::UIForm> form)
{
  Db_sql_editor::Ref editor= boost::dynamic_pointer_cast<Db_sql_editor>(form);
  
  if (!editor)
    throw std::logic_error("invalid backend object");

  WBSQLQueryPanel *panel= [[[WBSQLQueryPanel alloc] initWithBE: editor] autorelease];
  [panel setRightSidebar: [mainwin context]->get_wb()->get_wb_options().get_int("Sidebar:RightAligned", 0)];
  return panel;
}


void setupSQLQueryUI(WBMainController *main, WBMainWindow *mainwin, wb::WBContextUI *wbui)
{  
  wbui->get_command_ui()->add_builtin_command("query.execute", boost::bind(call_execute, wbui), 
                                              boost::bind(validate_query_panel_active, wbui));
  wbui->get_command_ui()->add_builtin_command("query.execute_current_statement", boost::bind(call_execute_current_statement, wbui), 
                                              boost::bind(validate_execute_current_statement, wbui));

  wbui->get_command_ui()->add_builtin_command("query.save_edits", boost::bind(call_save_edits, wbui), 
                                              boost::bind(validate_save_edits, wbui));
  wbui->get_command_ui()->add_builtin_command("query.discard_edits", boost::bind(call_discard_edits, wbui), 
                                              boost::bind(validate_discard_edits, wbui));
  
  // other commands in wb_context_sqlide.cpp

  [main registerFormPanelFactory:createQueryPanel forFormType: WB_MAIN_VIEW_DB_QUERY];
}

