using System;
using System.Windows.Forms;

namespace MySQL.GUI.Workbench
{
  public partial class ExceptionDialog : Form
  {
    private static ExceptionDialog singleton = new ExceptionDialog();

    private String errorInfo;

    protected ExceptionDialog()
    {
      InitializeComponent();
    }

    public static void Show(String message, String info)
    {
      singleton.messageLabel.Text = message;
      singleton.errorInfo = info;
      singleton.ShowDialog();
    }

    private void reportBugButton_Click(object sender, EventArgs e)
    {
      System.Diagnostics.Process.Start("http://bugs.mysql.com/report.php");
    }

    private void copyInfoButton_Click(object sender, EventArgs e)
    {
      Clipboard.SetText(errorInfo);
    }

    private void copyStackTraceToClipboardToolStripMenuItem_Click(object sender, EventArgs e)
    {
      Clipboard.SetText(errorInfo);
    }

  }
}
