using System;
using System.Windows.Forms;

using Aga.Controls.Tree;
using MySQL.Workbench;


namespace MySQL.GUI.Workbench
{
  public partial class SqlIdeSideBar : Form
  {
    WbContext wbContext;
    DbSqlEditor dbSqlEditor;

    public SqlIdeSideBar(WbContext WbContext)
    {
      wbContext = WbContext;

      InitializeComponent();
    }

    public void Refresh(DbSqlEditor dbSqlEditor)
    {
      RefreshEx(dbSqlEditor, false);
    }

    private delegate void RefreshExDelegate(DbSqlEditor dbSqlEditor, bool force);

    public void RefreshEx(DbSqlEditor dbSqlEditor, bool force)
    {
      if (InvokeRequired)
      {
        RefreshExDelegate f = new RefreshExDelegate(RefreshEx);
        Invoke(f, new Object[] { dbSqlEditor, force });
        return;
      }

      Control newSidebar = dbSqlEditor.Backend.get_sidebar_control();
      if (Controls.IndexOf(newSidebar) < 0)
      {
        Controls.Add(newSidebar);
        Controls.SetChildIndex(newSidebar, 0);
        newSidebar.Dock = DockStyle.Fill;
      }

      this.dbSqlEditor = dbSqlEditor;
    }

    private void ExpandNode(TreeNodeAdv node, int depth)
    {
      if (0 == depth)
      {
        node.Expand(true);
      }
      else
      {
        node.Expand(true);
        foreach (TreeNodeAdv childNode in node.Children)
          ExpandNode(childNode, depth - 1);
      }
    }

  }
}
