/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __BASE_LOG_H__
#define __BASE_LOG_H__

// These empty macroses will be redefined in log_impl.h
// We have them empty atm to allow compilation with missing ENABLE_LOG
#define log_error(...)
#define log_warning(...)
#define log_info(...)
#define log_debug(...)
#define log_debug2(...)

#define ENABLE_LOG(domain)\
	static const char* const log_domain = domain;\

#include "base/log_impl.h"

#endif

