#ifndef _DRIVER_MANAGER_H_
#define _DRIVER_MANAGER_H_


#include "cppdbc_public_interface.h"
#include "grts/structs.db.mgmt.h"
#include <cppconn/driver.h>
#include <boost/cstdint.hpp>
#include <boost/shared_ptr.hpp>
#include <memory>


namespace sql
{
typedef boost::shared_ptr<Connection> ConnectionPtr;

  
class TunnelConnection
{
public:
  virtual void connect(db_mgmt_ConnectionRef connectionProperties)= 0;
  virtual void disconnect()= 0;
  virtual int get_port()= 0;
};


class ConnectionWrapper
{
  ConnectionPtr _conn;
  boost::shared_ptr<TunnelConnection> _tunnel_conn;
public:
  ConnectionWrapper() {}
  ConnectionWrapper(std::auto_ptr<Connection> conn,TunnelConnection* tunn_conn):_conn(conn),_tunnel_conn(tunn_conn) {}
  void reset() {_conn.reset();}
  Connection* operator->() {return _conn.get();}
  Connection* get() {return _conn.get();}
  ConnectionPtr get_ptr() {return _conn;}
};


class CPPDBC_PUBLIC_FUNC DriverManager
{
  std::string _driver_path;
  std::list<Driver *> _drivers;

public:
  // Returns the DriverManager singleton
  static DriverManager *getDriverManager();

  DriverManager();

  // Sets the path to the directory where drivers are located
  void set_driver_dir(const std::string &path);

  // Callback to initialize connection with DBMS specific startup script
  typedef boost::function<void (Connection*, const db_mgmt_ConnectionRef&)> ConnectionInitSlot;

  // Returns a Connection object for the give connection params
  ConnectionWrapper getConnection(const db_mgmt_ConnectionRef &connectionProperties, ConnectionInitSlot connection_init_slot= ConnectionInitSlot());

  TunnelConnection *getTunnel(const db_mgmt_ConnectionRef &connectionProperties);
  
  // Returns the list of available drivers
  std::list<Driver *> getDrivers();
  
public:
  typedef boost::function<TunnelConnection* (const db_mgmt_ConnectionRef &)> TunnelFactoryFunction;
  typedef boost::function<bool (const db_mgmt_ConnectionRef &, std::string &)> PasswordFindFunction;
  typedef boost::function<std::string (const db_mgmt_ConnectionRef &, bool)> PasswordRequestFunction;

  void setTunnelFactoryFunction(TunnelFactoryFunction function);
  void setPasswordFindFunction(PasswordFindFunction function);
  void setPasswordRequestFunction(PasswordRequestFunction function);
  
private:
  TunnelFactoryFunction _createTunnel;
  PasswordFindFunction _findPassword;
  PasswordRequestFunction _requestPassword;
  
  std::string _cachedPassword;
  std::string _cacheKey;
  time_t _cacheTime;
};


class Dbc_connection_handler
{
public:
  Dbc_connection_handler() : id(-1), autocommit_mode(true), is_stop_query_requested(false) {}
  typedef boost::shared_ptr<Dbc_connection_handler> Ref;
  typedef ConnectionWrapper ConnectionRef;
  ConnectionRef ref;
  std::string name;
  boost::int64_t id;
  std::string active_schema;
  bool autocommit_mode;
  bool is_stop_query_requested;
};


} // namespace sql


#endif // _DRIVER_MANAGER_H_
