/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include <mforms/mforms.h>

using namespace mforms;


DrawBox::DrawBox()
{
  _drawbox_impl= &ControlFactory::get_instance()->_drawbox_impl;
  
  _drawbox_impl->create(this);
}

void DrawBox::set_needs_repaint()
{
  _drawbox_impl->set_needs_repaint(this);
}

/**
 * The content of a draw box is, by nature, drawn by the box itself, so we need to know what
 * space the box needs. Overwritten by descendants.
 */
void DrawBox::get_layout_size(int* w, int* h)
{
  *w= 0;
  *h= 0;
}