/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _LF_DRAWBOX_H_
#define _LF_DRAWBOX_H_

#include "mforms/label.h"

#include "lf_view.h"

namespace mforms {
namespace gtk {

class DrawBoxImpl : public ViewImpl
{
protected:
  Gtk::EventBox *_darea;
  Glib::Dispatcher _repaint;
  int _fixed_width;
  int _fixed_height;
  
  virtual Gtk::Widget *get_outer() const { return _darea; }

  DrawBoxImpl(::mforms::DrawBox *self);
  bool repaint(GdkEventExpose *event, ::mforms::DrawBox *self);
  void mouse_cross_event(GdkEventCrossing *event, ::mforms::DrawBox *self);
  void mouse_button_event(GdkEventButton *event, ::mforms::DrawBox *self);
  void mouse_move_event(GdkEventMotion *event, ::mforms::DrawBox *self);

  virtual void set_back_color(const std::string& s);

  static bool create(::mforms::DrawBox *self);
  static void set_needs_repaint(::mforms::DrawBox *self);

 public:
  static void init();

  virtual void set_size(int width, int height);
};

};
};


#endif /* _LF_DRAWBOX_H_ */
