/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _MFORMS_BASE_H_
#define _MFORMS_BASE_H_

#include <string>
#include <list>

#ifdef _WIN32
# ifdef DECL_MFORMS_EXPORT
#  define MFORMS_EXPORT __declspec(dllexport)
# else
#  define MFORMS_EXPORT __declspec(dllimport)
# endif
#else
# define MFORMS_EXPORT
#endif

#ifndef _WIN32
#define __stdcall 
#endif

#ifdef __APPLE__
#ifdef nil
#undef nil
#endif 
#define nil __DARWIN_NULL
#include <objc/objc-runtime.h>
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace mforms {

  // The root of of mforms hierarchy.
  class MFORMS_EXPORT Object
  {
  public:
    Object *retain()
    {
      _refcount++;
      return this;
    }

    void release()
    {
      --_refcount;
      if (_refcount == 0 && _managed)
        delete this;
    }
    
    virtual void set_managed()
    {
      _managed= true;
    }
    
    inline int retain_count() { return _refcount; };
    void set_destroying() { _destroying= true; };
    bool is_destroying() { return _destroying; };

#ifndef SWIG
    //! Note: set_data and get_data should be used exclusivelly by the implementation code
    //! for each platform.
#ifdef __APPLE__
  public:
    Object() : _data(nil), _refcount(1), _managed(false), _destroying(false)
    {
      
    }

    void set_data(id data) { objc_msgSend(data, sel_getUid("retain")); /* calls [data retain] */ _data= data; }
    id get_data() const { return _data; }
    
    virtual ~Object() { /*objc_msgSend(_data, sel_getUid("release"));*/ /* calls [_data release] */ }
  private:
    id _data;
#else // !__APPLE__
  public:
    Object() : _data(0), _data_free_fn(0), _refcount(1), _managed(false), _destroying(false)
    {
    }

    virtual ~Object()
    {
      if (_data_free_fn && _data)
        (*_data_free_fn)(_data);
    }

    typedef void (*FreeDataFn)(void*);
    void set_data(void *data, FreeDataFn free_fn = 0)
    {
      _data = data;
      _data_free_fn = free_fn;
    }

    template<class C>
      C* get_data() const { return reinterpret_cast<C*>(_data); }

    void *get_data_ptr() const { return _data; }

  private:
    void *_data;
    FreeDataFn _data_free_fn;
#endif // !__APPLE__
    int _refcount;
  protected:
    bool _managed;
#endif // !SWIG
  private:
    bool _destroying;
  };

  
  //! Makes the passed object be released when retain count reaches 0
  // Must be called for objects allocated with new that you won't delete manually
  template<class C>
    C* manage(C *obj)
    {
      obj->set_managed();
      return obj;
    }
};

#endif  // !DOXYGEN_SHOULD_SKIP_THIS
#endif
