/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
 
#include "stdafx.h"
#include "../stub_utilities.h"


namespace mforms {
namespace stub {

std::map<const std::string, std::string> UtilitiesImpl::passwords;
  

int __stdcall UtilitiesImpl::show_message(const std::string &title, const std::string &text,
                        const std::string &ok, const std::string &cancel,
                        const std::string &other)
{
  return 0;
}


int __stdcall UtilitiesImpl::show_error(const std::string &title, const std::string &text,
                      const std::string &ok, const std::string &cancel,
                      const std::string &other)
{
  return 0;
}

int __stdcall UtilitiesImpl::show_warning(const std::string &title, const std::string &text,
                      const std::string &ok, const std::string &cancel,
                      const std::string &other)
{
  return 0;
}

int __stdcall UtilitiesImpl::show_message_with_checkbox(const std::string &title, const std::string &text,
                      const std::string &ok, const std::string &cancel,
                      const std::string &other,
                      const std::string &checkbox_text, // empty text = default "Don't show this message again" text
                      bool &remember_checked)
{
  return 0;
}


void __stdcall UtilitiesImpl::show_wait_message(const std::string &title, const std::string &text)
{
}

bool __stdcall UtilitiesImpl::hide_wait_message()
{
  return true;
}

bool __stdcall UtilitiesImpl::run_cancelable_wait_message(const std::string &title, const std::string &text,
                      const sigc::slot<bool> &cancel_task)
{
  return true;
}

void __stdcall UtilitiesImpl::stop_cancelable_wait_message()
{
}

    
void __stdcall UtilitiesImpl::set_clipboard_text(const std::string &text)
{
}

std::string __stdcall UtilitiesImpl::get_clipboard_text()
{
  return "";
}


void __stdcall UtilitiesImpl::open_url(const std::string &url)
{
}

std::string __stdcall UtilitiesImpl::get_special_folder(mforms::FolderType type)
{
  return "./";
}

void __stdcall UtilitiesImpl::add_timeout(float interval, const sigc::slot<bool> &slot)
{
}

void __stdcall UtilitiesImpl::store_password(const std::string &service, const std::string &account, const std::string &password)
{
  passwords[account] = password;
}

//------------------------------------------------------------------------------
bool __stdcall UtilitiesImpl::find_password(const std::string &service, const std::string &account, std::string &password)
{
  bool ret_val = false;
  if (passwords.count(account))
  {
    password = passwords[account];
    ret_val = true;
  }

  return ret_val;
}

//------------------------------------------------------------------------------
void __stdcall UtilitiesImpl::forget_password(const std::string &service, const std::string &account)
{
}


//------------------------------------------------------------------------------
enum {Gnome_keyring_results_size = 10};
static const char* gnome_keyring_results[Gnome_keyring_results_size] = {"OK",
                                             "GNOME_KEYRING_RESULT_DENIED",
                                             "GNOME_KEYRING_RESULT_NO_KEYRING_DAEMON",
                                             "GNOME_KEYRING_RESULT_ALREADY_UNLOCKED",
                                             "GNOME_KEYRING_RESULT_NO_SUCH_KEYRING",
                                             "GNOME_KEYRING_RESULT_BAD_ARGUMENTS",
                                             "GNOME_KEYRING_RESULT_IO_ERROR",
                                             "GNOME_KEYRING_RESULT_CANCELLED",
                                             "GNOME_KEYRING_RESULT_ALREADY_EXISTS",
                                             ""
                                            };

//------------------------------------------------------------------------------
void UtilitiesImpl::init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

  f->_utilities_impl.show_message= &UtilitiesImpl::show_message;
  f->_utilities_impl.show_error= &UtilitiesImpl::show_error;
  f->_utilities_impl.show_warning= &UtilitiesImpl::show_warning;
  f->_utilities_impl.set_clipboard_text= &UtilitiesImpl::set_clipboard_text;
  f->_utilities_impl.get_clipboard_text= &UtilitiesImpl::get_clipboard_text;
  f->_utilities_impl.open_url= &UtilitiesImpl::open_url;
  f->_utilities_impl.add_timeout= &UtilitiesImpl::add_timeout;
  f->_utilities_impl.get_special_folder= &UtilitiesImpl::get_special_folder;
  f->_utilities_impl.store_password= &UtilitiesImpl::store_password;
  f->_utilities_impl.find_password= &UtilitiesImpl::find_password;
  f->_utilities_impl.forget_password= &UtilitiesImpl::forget_password;

  f->_utilities_impl.hide_wait_message= &UtilitiesImpl::hide_wait_message;
  f->_utilities_impl.run_cancelable_wait_message= &UtilitiesImpl::run_cancelable_wait_message;
  f->_utilities_impl.show_message_with_checkbox= &UtilitiesImpl::show_message_with_checkbox;
  f->_utilities_impl.show_wait_message= &UtilitiesImpl::show_wait_message;
  f->_utilities_impl.stop_cancelable_wait_message= &UtilitiesImpl::stop_cancelable_wait_message;
}

void UtilitiesImpl::set_open_url_slot(const sigc::slot<void,std::string> &slot)
{
}


};
};
