/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_MENUITEM_H_
#define _STUB_MENUITEM_H_


#include "mforms/button.h"

#include "stub_view.h"


namespace mforms {
namespace stub {

class MenuItemImpl : public ObjectImpl
{
 protected:
   MenuItemImpl(::mforms::MenuItem *self)
    : ObjectImpl(self)
  {
  }

  static bool __stdcall create_menu_bar(MenuBar *item)
  {
    return true;
  }

  static bool __stdcall create_menu_item(MenuItem *item, const std::string &, const MenuItemType type)
  {
    return true;
  }

  static void __stdcall set_title(MenuItem *item, const std::string&)
  {
  }

  static std::string __stdcall get_title(MenuItem *item)
  {
    return "";
  }

  static void __stdcall set_shortcut(MenuItem *item, const std::string&)
  {
  }

  static void __stdcall set_enabled(MenuBase *item, bool)
  {
  }

  static bool __stdcall get_enabled(MenuBase *item)
  {
    return true;
  }

  static void __stdcall set_checked(MenuItem *item, bool)
  {
  }

  static bool __stdcall get_checked(MenuItem *item)
  {
    return true;
  }

  static void __stdcall insert_item(MenuBase *menu, int index, MenuItem *item)
  {
  }

  static void __stdcall remove_item(MenuBase *menu, MenuItem *item)
  {
  }




public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_menu_item_impl.create_menu_bar = &MenuItemImpl::create_menu_bar;
    f->_menu_item_impl.create_menu_item = &MenuItemImpl::create_menu_item;
    f->_menu_item_impl.get_checked = &MenuItemImpl::get_checked;
    f->_menu_item_impl.get_enabled = &MenuItemImpl::get_enabled;
    f->_menu_item_impl.get_title = &MenuItemImpl::get_title;
    f->_menu_item_impl.insert_item = &MenuItemImpl::insert_item;
    f->_menu_item_impl.remove_item = &MenuItemImpl::remove_item;
    f->_menu_item_impl.set_checked = &MenuItemImpl::set_checked;
    f->_menu_item_impl.set_enabled = &MenuItemImpl::set_enabled;
    f->_menu_item_impl.set_shortcut = &MenuItemImpl::set_shortcut;
    f->_menu_item_impl.set_title = &MenuItemImpl::set_title;
  }
};

}
}

#endif
