/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_TREEVIEW_H_
#define _STUB_TREEVIEW_H_

#include <mforms/mforms.h>

#include "stub_view.h"

namespace mforms {
namespace stub {


class TreeViewImpl : public ViewImpl
{
private:
  TreeViewImpl(TreeView *self, mforms::TreeOptions opts);

  int add_column(TreeColumnType type, const std::string &name, int initial_width, bool editable);
  void end_columns();
  static bool __stdcall create(TreeView *self, mforms::TreeOptions opt);
  static int __stdcall add_column(TreeView *self, TreeColumnType type, const std::string &name, int width, bool editable);
  static void __stdcall end_columns(TreeView *self);
  static void __stdcall clear_rows(TreeView *self);
  static void __stdcall delete_row(TreeView *self, int row);
  static int __stdcall add_row(TreeView *self);
  static int __stdcall get_selected(TreeView *self);
  static void __stdcall set_selected(TreeView* self, const int idx);
  static int __stdcall count(TreeView *self);
  static void __stdcall set_string(TreeView *self, int row, int column, const std::string &value);
  static void __stdcall set_integer(TreeView *self, int row, int column, int value);
  static void __stdcall set_check(TreeView *self, int row, int column, bool check);
  static std::string __stdcall get_string(TreeView *self, int row, int column);
  static int __stdcall get_int(TreeView *self, int row, int column);
  static bool __stdcall get_check(TreeView *self, int row, int column);
  static std::string __stdcall get_row_tag(TreeView *self, int row);
  static void __stdcall set_row_tag(TreeView *self, int row, const std::string &value);
  static void __stdcall set_allow_sorting(TreeView *self, bool);
  static void __stdcall freeze_refresh(TreeView *self, bool);


public:
  static void init();
};

  
}
}

#endif
