/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_CHECKBOX_H_
#define _WF_CHECKBOX_H_

#include <mforms/mforms.h>

#include "wf_button.h"


using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class CheckBoxImpl : public ButtonImpl
    {
      static bool create(::mforms::CheckBox *self)
      {
        CheckBoxImpl ^cb= gcnew CheckBoxImpl(self);

        if (cb != nullptr)
        {
          CheckBox^ box= ViewImpl::create<CheckBox>(self, cb);
          box->ForeColor = System::Drawing::Color::Black;
          box->Click += gcnew System::EventHandler(&CheckBoxImpl::click);
          return true;
        }
        return false;
      }

      static void click(System::Object ^sender, System::EventArgs ^e)
      {
        Windows::Forms::CheckBox^ box= (Windows::Forms::CheckBox^)sender;

        if (box->Tag != nullptr)
        {
          ::mforms::Button* button= ViewImpl::get_backend_control<::mforms::Button>(box);
          if (button != 0)
            button->callback();
        }
      }

      static void set_active(::mforms::CheckBox *self, bool flag)
      {
        CheckBoxImpl^ cb= (CheckBoxImpl^)ObjectImpl::FromUnmanaged(self);

        if (cb != nullptr)
        {
          cb->get_control<CheckBox>()->Checked= flag;
        }
      }

      static bool get_active(::mforms::CheckBox *self)
      {
        CheckBoxImpl^ cb= (CheckBoxImpl^)ObjectImpl::FromUnmanaged(self);

        if (cb != nullptr)
        {
          return cb->get_control<CheckBox>()->Checked;
        }
        return false;
      }

      CheckBoxImpl(::mforms::CheckBox *cbox)
        : ButtonImpl(cbox)
      {
      }

    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::CheckBox*, mgr, f->_checkbox_impl, CheckBoxImpl, create);
        DEF_CALLBACK2(void, ::mforms::CheckBox*, bool, mgr, f->_checkbox_impl, CheckBoxImpl, set_active);
        DEF_CALLBACK1(bool, ::mforms::CheckBox*, mgr, f->_checkbox_impl, CheckBoxImpl, get_active);
      }
    };

  };
};

#endif
