/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_MENU_H_
#define _WF_MENU_H_

#include "mforms/mforms.h"
#include "mforms/menu.h"
#include "wf_base.h"
#include "wf_mforms.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class MenuImpl : public ObjectImpl
    {
    protected:
      MenuImpl(mforms::Menu *self);
      ~MenuImpl();

      static bool create(mforms::Menu* self);
      static void remove_item(mforms::Menu* self, int i);
      static int add_item(mforms::Menu* self, const std::string& caption, const std::string& action);
      static int add_separator(mforms::Menu* self);
      static int add_submenu(mforms::Menu* self, const std::string& caption, mforms::Menu* submenu);
      static void set_item_enabled(mforms::Menu* self, int i, bool flag);
      static void popup_at(mforms::Menu* self, mforms::Object* control, int x, int y);
      static void clear(mforms::Menu* self);

      void menuItemClick(Object^ sender, System::EventArgs^ e);
    public:
      static ContextMenu ^get(mforms::Menu *self);

      static void init(Manager^ mgr)
      {
        mforms::ControlFactory* f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::Menu*, mgr, f->_menu_impl, MenuImpl, create);
        DEF_CALLBACK2(void, mforms::Menu*, int, mgr, f->_menu_impl, MenuImpl, remove_item);
        DEF_CALLBACK3(int, mforms::Menu*, const std::string&, const std::string&, mgr, f->_menu_impl, MenuImpl, add_item);
        DEF_CALLBACK1(int, mforms::Menu*, mgr, f->_menu_impl, MenuImpl, add_separator);
        DEF_CALLBACK3(int, mforms::Menu*, const std::string&, mforms::Menu*, mgr, f->_menu_impl, MenuImpl, add_submenu);
        DEF_CALLBACK3(void, mforms::Menu*, int, bool, mgr, f->_menu_impl, MenuImpl, set_item_enabled);
        DEF_CALLBACK4(void, mforms::Menu*, mforms::Object*, int, int, mgr, f->_menu_impl, MenuImpl, popup_at);
        DEF_CALLBACK1(void, mforms::Menu*, mgr, f->_menu_impl, MenuImpl, clear);
      }
    };

  };
};

#endif // _WF_MENU_H_
