#ifndef __WB_MYSQL_TABLE_EDITOR_TRIGGER_PAGE_H__
#define __WB_MYSQL_TABLE_EDITOR_TRIGGER_PAGE_H__

#include "grt/tree_model.h"
#include "sql_editor_fe.h"
#include "errors_list.h"
#include <gtkmm/builder.h>

class MySQLTableEditorBE;
class ListModelWrapper;
class DbMySQLTableEditor;

//==============================================================================
//
//==============================================================================
class DbMySQLTableEditorTriggerPage
{
  public:
    DbMySQLTableEditorTriggerPage(DbMySQLTableEditor *owner, MySQLTableEditorBE* be, Glib::RefPtr<Gtk::Builder> xml);
    ~DbMySQLTableEditorTriggerPage();

    void refresh();

    void switch_be(MySQLTableEditorBE* be);  
  private:
    void parse_sql(const std::string& sql);
    void error_selected(const int lineno, const std::string& msg);

    DbMySQLTableEditor                       *_owner;
    MySQLTableEditorBE                       *_be;
    Glib::RefPtr<Gtk::Builder>                               _xml;

    SqlEditorFE                               _trigger_code;
};

#endif
