#ifndef _DB_ALTER_SCRIPT_H_
#define _DB_ALTER_SCRIPT_H_

#include "grtui/grt_wizard_plugin.h"
#include "grtui/wizard_view_text_page.h"
#include "mforms/fs_object_selector.h"

struct DataSourceSelector: public base::trackable
{
    enum SourceType
    {
      ModelSource= 0,
      ServerSource= 1,
      FileSource= 2
    };

    mforms::Panel panel;
    mforms::Box box;
    mforms::RadioButton* model_radio;
    mforms::RadioButton* server_radio;
    mforms::RadioButton* file_radio;
    mforms::Box browse_box;
    mforms::FsObjectSelector file_selector;

    DataSourceSelector(bool SaveFile = false)
      : panel(::mforms::TitledBoxPanel), box(false), browse_box(true), file_selector(true)
    {
      box.set_spacing(4);
      box.set_padding(12);
      box.set_homogeneous(true);
      panel.add(&box);

      int group= mforms::RadioButton::new_id();
      model_radio= mforms::manage(new mforms::RadioButton(group));
      server_radio= mforms::manage(new mforms::RadioButton(group));
      file_radio= mforms::manage(new mforms::RadioButton(group));

      box.add(model_radio, false, false);
      model_radio->set_text(_("Model Schemata"));
      box.add(server_radio, false, false);
      server_radio->set_text(_("Live Database Server"));
      file_radio->set_text(_("Script File:"));
      box.add(&browse_box, false, false);

      browse_box.set_spacing(8);
      browse_box.add(file_radio, false,true);
      browse_box.add(&file_selector, true, true);

      file_selector.initialize("", SaveFile?mforms::SaveFile:mforms::OpenFile, "SQL Files (*.sql)|*.sql", _("Browse..."));
      scoped_connect(file_radio->signal_toggled(),boost::bind(&DataSourceSelector::file_source_selected, this));
    }

    void file_source_selected()
    {
      file_selector.set_enabled(file_radio->get_active());
    }

    void set_change_slot(const boost::function<void()> &change_slot)
    {
      scoped_connect(model_radio->signal_toggled(),change_slot);
      scoped_connect(server_radio->signal_toggled(),change_slot);
      scoped_connect(file_radio->signal_toggled(),change_slot);
    }

    SourceType get_source()
    {
      if (model_radio->get_active())
        return ModelSource;
      else if (server_radio->get_active())
        return ServerSource;
      else
        return FileSource;
    }
  };

#endif //#define _DB_ALTER_SCRIPT_H_