#include "stdafx.h"

#include "wb_config.h"

#include "grtui/grt_wizard_plugin.h"
#include "grtui/wizard_progress_page.h"
#include "grtui/wizard_schema_filter_page.h"
#include "grtui/wizard_object_filter_page.h"
#include "grtui/wizard_finished_page.h"
#include "grtui/wizard_view_text_page.h"
#include "grtui/grtdb_connect_panel.h"


#include "diff_tree.h"
#include "db_mysql_sql_script_sync.h"

#include "db_mysql_sql_sync.h"


using namespace grtui;
using namespace mforms;


namespace DBSynchronize
{
  
class ConnectionPage;
class FetchSchemaNamesProgressPage;
class SchemaSelectionPage;
class FetchSchemaContentsProgressPage;
class ObjectSelectionPage;
class ReviewScriptPage;
class DBSynchronizeProgressPage;
class FinishPage;


#include "grtui/connection_page.h"

#include "fetch_schema_names_page.h"

//--------------------------------------------------------------------------------

#include "schema_selection_page.h"

//--------------------------------------------------------------------------------

#include "fetch_schema_contents_page.h"

//--------------------------------------------------------------------------------

#include "synchronize_differences_page.h"

//--------------------------------------------------------------------------------

class WbPluginDbSynchronize : public WizardPlugin
{
  DbMySQLScriptSync _be;
  DbMySQLSync _db_be;
  
  
  std::vector<std::string> load_schemata()
  {
    std::vector<std::string> schema_names;

    _db_be.load_schemata(schema_names);
    return schema_names;
  }

public:
  WbPluginDbSynchronize(grt::Module *module);
  
  DbMySQLScriptSync *get_be() { return &_be; }

  DbMySQLSync *get_db_be() { return &_db_be; }
};


//--------------------------------------------------------------------------------

class PreviewScriptPage : public ViewTextPage
{
  mforms::CheckBox _model_only;
public:
  PreviewScriptPage(WizardForm *form)
  : ViewTextPage(form, "preview", (ViewTextPage::Buttons)(ViewTextPage::CopyButton|ViewTextPage::SaveButton), "SQL Scripts (*.sql)|*.sql")
  {
    set_title(_("Preview Database Changes to be Applied"));
    set_short_title(_("Review DB Changes"));
    
    set_editable(true);

    _model_only.set_text("Skip DB changes and update model only");
    _button_box.add(&_model_only, true, true);
    
    scoped_connect(signal_leave(),boost::bind(&PreviewScriptPage::apply_changes, this, _1));
  }


  virtual void enter(bool advancing)
  {
    if (advancing)
      set_text(((WbPluginDbSynchronize*)_form)->get_be()->generate_diff_tree_script());
  }
  
  virtual bool advance()
  {
    // check if there is anything to be DROPPED and warn user
    //TODO XXX

    return ViewTextPage::advance();
  }

  void apply_changes(bool advancing)
  {
    values().gset("UpdateModelOnly", _model_only.get_active()?1:0);
    ((WbPluginDbSynchronize*)_form)->get_db_be()->set_option("ScriptToApply", get_text());//TODO: does this seves any purpose any more?
    ((WbPluginDbSynchronize*)_form)->get_db_be()->sql_script(get_text());
  }
  
  virtual std::string next_button_caption() { return execute_caption(); }
};


//--------------------------------------------------------------------------------

class DBSynchronizeProgressPage : public WizardProgressPage
{
  TaskRow *db_task;
  
public:
  DBSynchronizeProgressPage(WbPluginDbSynchronize *form)
    : WizardProgressPage(form, "importProgress")
  {    
    set_title(_("Progress of Model and Database Synchronization"));
    set_short_title(_("Synchronize Progress"));

    db_task = add_async_task(_("Apply Changes to Database"),
                   boost::bind(&DBSynchronizeProgressPage::perform_sync_db, this),
                   _("Applying selected changes from model to the database..."));

    add_task(_("Apply Changes to Model"),
             boost::bind(&DBSynchronizeProgressPage::perform_sync_model, this),
             _("Applying selected changes from database to the model..."));

    end_adding_tasks(true,
                     _("Synchronization Completed Successfully"));

    set_status_text("");
  }


  virtual void enter(bool advancing)
  {    
    if (values().get_int("UpdateModelOnly"))
      db_task->set_enabled(false);
    else
      db_task->set_enabled(true);
    
    WizardProgressPage::enter(advancing);
  }

  bool perform_sync_db()
  {
    _form->grtm()->get_grt()->send_info("Applying synchronization scripts to server...");
    
    execute_grt_task(boost::bind(&Db_plugin::apply_script_to_db, ((WbPluginDbSynchronize*)_form)->get_db_be(), _1), false);
    
    return true;
  }
  
  bool perform_sync_model()
  {
    _form->grtm()->get_grt()->send_info("Updating model...");
    
    if (!_got_error_messages)
    {
      ((WbPluginDbSynchronize*)_form)->get_be()->update_model_old_names();
    }

    ((WbPluginDbSynchronize*)_form)->get_be()->apply_changes_to_model();

    return true;
  }
  
  virtual bool allow_back() { return false; }
  virtual bool allow_cancel() { return false; }

  virtual bool next_closes_wizard() { return true; }
};


//--------------------------------------------------------------------------------


WbPluginDbSynchronize::WbPluginDbSynchronize(grt::Module *module)
  : WizardPlugin(module), _be(grtm()), _db_be(grtm())
{  
  // add validation here
  
  ConnectionPage *connection_page= new ConnectionPage(this);
  connection_page->set_db_connection(_db_be.db_conn());
  add_page(mforms::manage(connection_page));

  FetchSchemaNamesProgressPage *fetch_progress_page= new FetchSchemaNamesProgressPage(this);
  fetch_progress_page->set_db_connection(_db_be.db_conn());
  fetch_progress_page->set_load_schemata_slot(boost::bind(&WbPluginDbSynchronize::load_schemata, this));
  add_page(mforms::manage(fetch_progress_page));

  SchemaSelectionPage *schema_selection_page= new SchemaSelectionPage(this,"pickSchemata",true);
  schema_selection_page->set_db_plugin(&_db_be);
  schema_selection_page->set_title(_("Select Schemata to Synchronize"));
  add_page(mforms::manage(schema_selection_page));

  FetchSchemaContentsProgressPage *fetch_contents_page= new FetchSchemaContentsProgressPage(this);
  fetch_contents_page->set_db_plugin(&_db_be);
  add_page(mforms::manage(fetch_contents_page));

  SynchronizeDifferencesPage *diffs_page= new SynchronizeDifferencesPage(this, &_be);
  diffs_page->set_title(_("Model and Database Differences"));
  diffs_page->set_source_catalog_slot(boost::bind(&Db_plugin::db_catalog, &_db_be));
  add_page(mforms::manage(diffs_page));
  
  add_page(mforms::manage(new PreviewScriptPage(this)));
  add_page(mforms::manage(new DBSynchronizeProgressPage(this)));

  set_title("Synchronize Model with Database");
}


}; // namespace DBSynchronize

grtui::WizardPlugin *createDbSynchronizeWizard(grt::Module *module, db_CatalogRef catalog)
{
  return new DBSynchronize::WbPluginDbSynchronize(module);
}

