# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; version 2 of the
# License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301  USA

class Option:
  def __init__(self, var, versions, description):
    self.var = var
    self.versions = versions
    self.description = description

  def __repr__(self):
    s = []
    for attr in dir(self):
      if attr[0] == '_':
        continue
      else:
        s.append("'" + attr + "':" + str(getattr(self, attr)))
    return '(' + (','.join(s)) + ')'



vars_list = {
'status' : {
     'Binlog' : (
        Option(var='Binlog_cache_disk_use' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of transactions that used a temporary file instead of the temporary binary log cache ')
       ,Option(var='Binlog_cache_use' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of transactions that used the temporary binary log cache ')
       ,Option(var='Com_show_binlog_events' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW BINLOG EVENTS statements ')
       ,Option(var='Com_show_binlogs' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW BINLOGS statements ')
     ) # End of section Binlog
     ,'Replication' : (
        Option(var='Com_change_master' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CHANGE MASTER statements ')
       ,Option(var='Com_load_master_data' ,versions=((4, 1),) ,description=' Count of LOAD MASTER DATA statements ')
       ,Option(var='Com_load_master_table' ,versions=((4, 1),) ,description=' Count of LOAD MASTER TABLE statements ')
       ,Option(var='Com_show_master_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW MASTER STATUS statements ')
       ,Option(var='Com_show_new_master' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW NEW MASTER statements ')
       ,Option(var='Com_show_slave_hosts' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW SLAVE HOSTS statements ')
       ,Option(var='Com_show_slave_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW SLAVE STATUS statements ')
       ,Option(var='Com_slave_start' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SLAVE START statements ')
       ,Option(var='Com_slave_stop' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SLAVE STOP statements ')
       ,Option(var='Rpl_semi_sync_master_clients' ,versions=((5, 5), (6, 0, 8)) ,description=' The number of semisynchronous slaves ')
       ,Option(var='Rpl_semi_sync_master_net_avg_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_net_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_net_waits' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_no_times' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_no_tx' ,versions=((5, 5), (6, 0, 8)) ,description=' The number of commits not acknowledged successfully ')
       ,Option(var='Rpl_semi_sync_master_status' ,versions=((5, 5), (6, 0, 8)) ,description=' Whether semisynchronous replication is operational on master ')
       ,Option(var='Rpl_semi_sync_master_timefunc_failures' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_tx_avg_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_tx_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_tx_waits' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_wait_pos_backtraverse' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_wait_sessions' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='Rpl_semi_sync_master_yes_tx' ,versions=((5, 5), (6, 0, 8)) ,description=' The number of commits acknowledged successfully ')
       ,Option(var='Rpl_semi_sync_slave_status' ,versions=((5, 5), (6, 0, 8)) ,description=' Whether semisynchronous replication is operational on slave ')
       ,Option(var='Rpl_status' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The status of fail-safe replication (not yet implemented) ')
       ,Option(var='Slave_heartbeat_period' ,versions=((5, 1, 22), (5, 5), (6, 0, 4)) ,description=' The slave\'s replication heartbeat interval, in seconds ')
       ,Option(var='Slave_open_temp_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of temporary tables that the slave SQL thread currently has open ')
       ,Option(var='Slave_received_heartbeats' ,versions=((5, 1, 22), (5, 5), (6, 0, 4)) ,description=' Number of heartbeats received by a replication slave since previous reset ')
       ,Option(var='Slave_retried_transactions' ,versions=((5, 0, 4), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total number of times since startup that the replication slave SQL thread has retried transactions ')
       ,Option(var='Slave_running' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The state of this server as a replication slave (slave I/O thread status) ')
     ) # End of section Replication
     ,'Ndb' : (
        Option(var='Handler_discover' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Indicates the number of times that tables have been discovered ')
       ,Option(var='Ndb_cluster_connection_pool' ,versions=((5, 1, 19),) ,description=' The number of connections to the cluster used by MySQL ')
       ,Option(var='Ndb_cluster_node_id' ,versions=((5, 0), (5, 1), (6, 0)) ,description=' If the server is acting as a MySQL Cluster node, then the value of this variable its node ID in the cluster ')
       ,Option(var='Ndb_cluster_node_id' ,versions=((5, 0, 45), (5, 1, 15)) ,description=' MySQL Cluster node ID for this MySQL server ')
       ,Option(var='Ndb_config_from_host' ,versions=((5, 0, 23), (5, 1, 12), (6, 0)) ,description=' The host name or IP address of the Cluster management server. Formerly Ndb_connected_host ')
       ,Option(var='Ndb_config_from_port' ,versions=((5, 0, 23), (5, 1, 12), (6, 0)) ,description=' The port for connecting to the Cluster management server. Formerly Ndb_connected_port ')
       ,Option(var='Ndb_conflict_fn_max' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=' If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that conflict resolution based on "greater timestamp wins" has been applied ')
       ,Option(var='Ndb_conflict_fn_old' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=' If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that "same timestamp wins" conflict resolution has been applied ')
       ,Option(var='Ndb_execute_count' ,versions=((5, 1, 22),) ,description=' Provides the number of round trips to the NDB kernel made by operations ')
       ,Option(var='Ndb_number_of_data_nodes' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=' If the server is part of a MySQL Cluster, the value of this variable is the number of data nodes in the cluster ')
       ,Option(var='Ndb_pruned_scan_count' ,versions=((5, 1, 32), (5, 1, 32)) ,description=' The number of scans executed by NDB since the cluster was last started where partition pruning could be used ')
       ,Option(var='Ndb_scan_count' ,versions=((5, 1, 32), (5, 1, 32)) ,description=' The total number of scans executed by NDB since the cluster was last started ')
     ) # End of section Ndb
     ,'Server' : (
        Option(var='Aborted_clients' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The number of connections aborted because the client died without closing the connection properly ')
       ,Option(var='Aborted_connects' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of failed attempts to connect to the MySQL server ')
       ,Option(var='Bytes_received' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of bytes received from all clients ')
       ,Option(var='Bytes_sent' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of bytes sent to all clients ')
       ,Option(var='Com_admin_commands' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of admin commands ')
       ,Option(var='Com_alter_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of ALTER DATABASE statements ')
       ,Option(var='Com_alter_db_upgrade' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_alter_db_upgrade ')
       ,Option(var='Com_alter_event' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count for ALTER EVENT statements ')
       ,Option(var='Com_alter_function' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of ALTER FUNCTION statements ')
       ,Option(var='Com_alter_procedure' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_alter_procedure ')
       ,Option(var='Com_alter_server' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_alter_server ')
       ,Option(var='Com_alter_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of ALTER TABLE statements ')
       ,Option(var='Com_alter_tablespace' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_alter_tablespace ')
       ,Option(var='Com_analyze' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of ANALYZE statements ')
       ,Option(var='Com_assign_to_keycache' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_assign_to_keycache ')
       ,Option(var='Com_backup' ,versions=((6, 0),) ,description=' Count of BACKUP DATABASE statements ')
       ,Option(var='Com_backup_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of BACKUP TABLE statements ')
       ,Option(var='Com_begin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of BEGIN statements ')
       ,Option(var='Com_binlog' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_binlog ')
       ,Option(var='Com_call_procedure' ,versions=((5, 0, 44), (5, 1, 19), (5, 4), (5, 5), (6, 0)) ,description=' Number of calls to stored procedures ')
       ,Option(var='Com_change_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CHANGE DATABASE statements ')
       ,Option(var='Com_check' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CHECK statements ')
       ,Option(var='Com_checksum' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CHECKSUM statements ')
       ,Option(var='Com_commit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of COMMIT statements ')
       ,Option(var='Com_create_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CREATE DATABASE statements ')
       ,Option(var='Com_create_event' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CREATE EVENT statements ')
       ,Option(var='Com_create_function' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CREATE FUNCTION statements ')
       ,Option(var='Com_create_index' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CREATE INDEX statements ')
       ,Option(var='Com_create_procedure' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_create_procedure ')
       ,Option(var='Com_create_server' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_create_server ')
       ,Option(var='Com_create_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of CREATE TABLE statements ')
       ,Option(var='Com_create_trigger' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_create_trigger ')
       ,Option(var='Com_create_udf' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_create_udf ')
       ,Option(var='Com_create_user' ,versions=((5, 0, 30), (5, 1), (5, 4), (6, 0)) ,description=' Count of CREATE USER statements ')
       ,Option(var='Com_create_view' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_create_view ')
       ,Option(var='Com_dealloc_sql' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DEALLOCATE PREPARE statements ')
       ,Option(var='Com_delete' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DELETE statements ')
       ,Option(var='Com_delete_multi' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of multiple table DELETE statements ')
       ,Option(var='Com_do' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DO statements ')
       ,Option(var='Com_drop_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DROP DATABASE statements ')
       ,Option(var='Com_drop_event' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DROP EVENT statements ')
       ,Option(var='Com_drop_function' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DROP FUNCTION statements ')
       ,Option(var='Com_drop_index' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DROP INDEX statements ')
       ,Option(var='Com_drop_procedure' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_drop_procedure ')
       ,Option(var='Com_drop_server' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_drop_server ')
       ,Option(var='Com_drop_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DROP TABLE statements ')
       ,Option(var='Com_drop_trigger' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_drop_trigger ')
       ,Option(var='Com_drop_user' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of DROP USER statements ')
       ,Option(var='Com_drop_view' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_drop_view ')
       ,Option(var='Com_empty_query' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_empty_query ')
       ,Option(var='Com_execute_sql' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of EXECUTE statements ')
       ,Option(var='Com_flush' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of FLUSH statements ')
       ,Option(var='Com_grant' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of GRANT statements ')
       ,Option(var='Com_ha_close' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of HANDLER CLOSE statements ')
       ,Option(var='Com_ha_open' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of HANDLER OPEN statements ')
       ,Option(var='Com_ha_read' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of HANDLER READ statements ')
       ,Option(var='Com_help' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of HELP statements ')
       ,Option(var='Com_insert' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of INSERT statements ')
       ,Option(var='Com_insert_select' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of INSERT SELECT statements ')
       ,Option(var='Com_install_plugin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_install_plugin ')
       ,Option(var='Com_kill' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of KILL statements ')
       ,Option(var='Com_load' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of LOAD statements ')
       ,Option(var='Com_load_master_data' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_load_master_data ')
       ,Option(var='Com_load_master_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_load_master_table ')
       ,Option(var='Com_lock_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of LOCK TABLES statements ')
       ,Option(var='Com_optimize' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of OPTIMIZE statements ')
       ,Option(var='Com_preload_keys' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of PRELOAD KEYS statements ')
       ,Option(var='Com_prepare_sql' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of PREPARE statements ')
       ,Option(var='Com_purge' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of PURGE statements ')
       ,Option(var='Com_purge_before_date' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of PURGE BEFORE DATE statements ')
       ,Option(var='Com_release_savepoint' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_release_savepoint ')
       ,Option(var='Com_rename_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of RENAME TABLE statements ')
       ,Option(var='Com_rename_user' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_rename_user ')
       ,Option(var='Com_repair' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of REPAIR statements ')
       ,Option(var='Com_replace' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of REPLACE statements ')
       ,Option(var='Com_replace_select' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of REPLACE SELECT statements ')
       ,Option(var='Com_reset' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of RESET statements ')
       ,Option(var='Com_restore' ,versions=((6, 0),) ,description=' Count of RESTORE DATABASE statements ')
       ,Option(var='Com_restore_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of RESTORE TABLE statements ')
       ,Option(var='Com_revoke' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of REVOKE statements ')
       ,Option(var='Com_revoke_all' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of REVOKE ALL statements ')
       ,Option(var='Com_rollback' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of ROLLBACK statements ')
       ,Option(var='Com_rollback_to_savepoint' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_rollback_to_savepoint ')
       ,Option(var='Com_savepoint' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SAVEPOINT statements ')
       ,Option(var='Com_select' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SELECT statements ')
       ,Option(var='Com_set_option' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SET OPTION statements ')
       ,Option(var='Com_show_authors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_authors ')
       ,Option(var='Com_show_charsets' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW CHARSET statements ')
       ,Option(var='Com_show_collations' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW COLLATION statements ')
       ,Option(var='Com_show_column_types' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW COLUMN TYPES statements ')
       ,Option(var='Com_show_contributors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_contributors ')
       ,Option(var='Com_show_create_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW CREATE DATABASE statements ')
       ,Option(var='Com_show_create_event' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW CREATE EVENT statements ')
       ,Option(var='Com_show_create_func' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_create_func ')
       ,Option(var='Com_show_create_proc' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_create_proc ')
       ,Option(var='Com_show_create_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW CREATE TABLE statements ')
       ,Option(var='Com_show_create_trigger' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_create_trigger ')
       ,Option(var='Com_show_databases' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW DATABASES statements ')
       ,Option(var='Com_show_engine_logs' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW ENGINE LOGS statements ')
       ,Option(var='Com_show_engine_mutex' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW ENGINE MUTEX statements ')
       ,Option(var='Com_show_engine_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW ENGINE STATUS statements ')
       ,Option(var='Com_show_errors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW ERRORS statements ')
       ,Option(var='Com_show_events' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW EVENTS statements ')
       ,Option(var='Com_show_fields' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW FIELDS statements ')
       ,Option(var='Com_show_function_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_function_status ')
       ,Option(var='Com_show_grants' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW GRANTS statements ')
       ,Option(var='Com_show_keys' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW KEYS statements ')
       ,Option(var='Com_show_logs' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW LOGS statements ')
       ,Option(var='Com_show_open_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW OPEN TABLES statements ')
       ,Option(var='Com_show_plugins' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW PLUGINS statements ')
       ,Option(var='Com_show_privileges' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW PRIVILEGES statements ')
       ,Option(var='Com_show_procedure_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_procedure_status ')
       ,Option(var='Com_show_processlist' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW PROCESSLIST statements ')
       ,Option(var='Com_show_profile' ,versions=((5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' Count of SHOW PROFILE statements ')
       ,Option(var='Com_show_profiles' ,versions=((5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' Count of SHOW PROFILES statements ')
       ,Option(var='Com_show_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW STATUS statements ')
       ,Option(var='Com_show_storage_engines' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW STORAGE ENGINES statements ')
       ,Option(var='Com_show_table_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_show_table_status ')
       ,Option(var='Com_show_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW TABLES statements ')
       ,Option(var='Com_show_triggers' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW TRIGGERS statements ')
       ,Option(var='Com_show_variables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW VARIABLES statements ')
       ,Option(var='Com_show_warnings' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW WARNINGS statements ')
       ,Option(var='Com_stmt_close' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of STATEMENT CLOSE statements ')
       ,Option(var='Com_stmt_execute' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of STATEMENT EXECUTE statements ')
       ,Option(var='Com_stmt_fetch' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of STATEMENT FETCH statements ')
       ,Option(var='Com_stmt_prepare' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of STATEMENT PREPARE statements ')
       ,Option(var='Com_stmt_reprepare' ,versions=((5, 1, 25), (5, 4), (5, 5), (6, 0, 6)) ,description=' Count of automatic repreparations of prepared statements ')
       ,Option(var='Com_stmt_reset' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of STATEMENT RESET statements ')
       ,Option(var='Com_stmt_send_long_data' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of STATEMENT SEND LONG DATA statements ')
       ,Option(var='Com_truncate' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of TRUNCATE statements ')
       ,Option(var='Com_uninstall_plugin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Com_uninstall_plugin ')
       ,Option(var='Com_unlock_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of UNLOCK TABLES statements ')
       ,Option(var='Com_update' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of UPDATE statements ')
       ,Option(var='Com_update_multi' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of multiple UPDATE statements ')
       ,Option(var='Com_xa_commit' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of XA COMMIT statements ')
       ,Option(var='Com_xa_end' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of XA END statements ')
       ,Option(var='Com_xa_prepare' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of XA PREPARE statements ')
       ,Option(var='Com_xa_recover' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of XA RECOVER statements ')
       ,Option(var='Com_xa_rollback' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of XA ROLLBACK statements ')
       ,Option(var='Com_xa_start' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of XA START statements ')
       ,Option(var='Compression' ,versions=((5, 0, 16), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Whether the client connection uses compression in the client/server protocol ')
       ,Option(var='Connections' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of connection attempts ')
       ,Option(var='Created_tmp_disk_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of temporary tables on disk created automatically by the server while executing statements ')
       ,Option(var='Created_tmp_files' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' How many temporary files mysqld has created ')
       ,Option(var='Created_tmp_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' How many temporary tables mysqld has created ')
       ,Option(var='Delayed_errors' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of rows written with INSERT DELAYED for which some error occurred ')
       ,Option(var='Delayed_insert_threads' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of INSERT DELAYED thread handlers in use ')
       ,Option(var='Delayed_writes' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of INSERT DELAYED rows written ')
       ,Option(var='Flush_commands' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of FLUSH statements executed ')
       ,Option(var='Handler_commit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of internal COMMIT statements ')
       ,Option(var='Handler_delete' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of times that rows have been deleted from tables ')
       ,Option(var='Handler_prepare' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' A counter for the prepare phase of two-phase commit operations ')
       ,Option(var='Handler_read_first' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of times the first entry in an index was read ')
       ,Option(var='Handler_read_key' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to read a row based on a key ')
       ,Option(var='Handler_read_next' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to read the next row in key order ')
       ,Option(var='Handler_read_prev' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to read the previous row in key order ')
       ,Option(var='Handler_read_rnd' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to read a row based on a fixed position ')
       ,Option(var='Handler_read_rnd_next' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to read the next row in the data file ')
       ,Option(var='Handler_rollback' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests for a storage engine to perform a rollback operation ')
       ,Option(var='Handler_savepoint' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests for a storage engine to place a savepoint ')
       ,Option(var='Handler_savepoint_rollback' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests for a storage engine to roll back to a savepoint ')
       ,Option(var='Handler_update' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to update a row in a table ')
       ,Option(var='Handler_write' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to insert a row in a table ')
       ,Option(var='Key_blocks_not_flushed' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of key blocks in the key cache that have changed but have not yet been flushed to disk ')
       ,Option(var='Key_blocks_unused' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of unused blocks in the key cache ')
       ,Option(var='Key_blocks_used' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of used blocks in the key cache ')
       ,Option(var='Key_read_requests' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to read a key block from the cache ')
       ,Option(var='Key_reads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of physical reads of a key block from disk ')
       ,Option(var='Key_write_requests' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of requests to write a key block to the cache ')
       ,Option(var='Key_writes' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of physical writes of a key block from disk ')
       ,Option(var='Last_query_cost' ,versions=((5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total cost of the last compiled query as computed by the query optimizer ')
       ,Option(var='Max_used_connections' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum number of connections that have been in use simultaneously since the server started ')
       ,Option(var='Not_flushed_delayed_rows' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of rows waiting to be written in INSERT DELAY queues ')
       ,Option(var='Open_files' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of files that are open ')
       ,Option(var='Open_streams' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of streams that are open (used mainly for logging) ')
       ,Option(var='Open_table_definitions' ,versions=((5, 1, 3), (5, 4), (5, 5), (6, 0)) ,description=' The number of .frm files in the table cache ')
       ,Option(var='Open_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of tables that are open ')
       ,Option(var='Opened_files' ,versions=((5, 1, 21), (5, 4), (5, 5), (6, 0)) ,description=' The number of files that have been opened using my_open() ')
       ,Option(var='Opened_table_definitions' ,versions=((5, 1, 24), (5, 4), (5, 5), (6, 0, 4)) ,description=' The number of .frm files that have been cached ')
       ,Option(var='Opened_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of tables that have been opened ')
       ,Option(var='Prepared_stmt_count' ,versions=((4, 1, 23), (5, 0, 32), (5, 1, 14), (5, 4), (6, 0)) ,description=' The current number of prepared statements ')
       ,Option(var='Qcache_free_blocks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of free memory blocks in the query cache ')
       ,Option(var='Qcache_free_memory' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The amount of free memory for the query cache ')
       ,Option(var='Qcache_hits' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of query cache hits ')
       ,Option(var='Qcache_inserts' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of query cache inserts ')
       ,Option(var='Qcache_lowmem_prunes' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of queries that were deleted from the query cache due to lack of free memory in the cache ')
       ,Option(var='Qcache_not_cached' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of noncached queries (not cacheable, or not cached due to the query_cache_type setting) ')
       ,Option(var='Qcache_queries_in_cache' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of queries registered in the query cache ')
       ,Option(var='Qcache_total_blocks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total number of blocks in the query cache ')
       ,Option(var='Queries' ,versions=((5, 0, 76), (5, 1, 31), (5, 4), (5, 5), (6, 0, 10)) ,description=' The number of statements executed by the server ')
       ,Option(var='Questions' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of statements that clients have sent to the server ')
       ,Option(var='Select_full_join' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of joins that perform table scans because they do not use indexes ')
       ,Option(var='Select_full_range_join' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of joins that used a range search on a reference table ')
       ,Option(var='Select_range' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of joins that used ranges on the first table ')
       ,Option(var='Select_range_check' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of joins without keys that check for key usage after each row ')
       ,Option(var='Select_scan' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of joins that did a full scan of the first table ')
       ,Option(var='Slow_launch_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of threads that have taken more than slow_launch_time seconds to create ')
       ,Option(var='Slow_queries' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of queries that have taken more than long_query_time seconds ')
       ,Option(var='Sort_range' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of sorts that were done using ranges ')
       ,Option(var='Sort_rows' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of sorted rows ')
       ,Option(var='Sort_scan' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of sorts that were done by scanning the table ')
       ,Option(var='Ssl_accept_renegotiates' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of negotiates needed to establish the connection ')
       ,Option(var='Ssl_accepts' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of accepted SSL connections ')
       ,Option(var='Ssl_callback_cache_hits' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of callback cache hits ')
       ,Option(var='Ssl_cipher' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The current SSL cipher ')
       ,Option(var='Ssl_cipher_list' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The list of possible SSL ciphers ')
       ,Option(var='Ssl_client_connects' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of SSL connection attempts to an SSL-enabled master ')
       ,Option(var='Ssl_connect_renegotiates' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of negotiates needed to establish the connection to an SSL-enabled master ')
       ,Option(var='Ssl_ctx_verify_depth' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The SSL context verification depth (how many certificates in the chain are tested) ')
       ,Option(var='Ssl_ctx_verify_mode' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The SSL context verification mode ')
       ,Option(var='Ssl_default_timeout' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The default SSL timeout ')
       ,Option(var='Ssl_finished_accepts' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of successful SSL connections to the server ')
       ,Option(var='Ssl_finished_connects' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of successful slave connections to an SSL-enabled master ')
       ,Option(var='Ssl_session_cache_hits' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of SSL session cache hits ')
       ,Option(var='Ssl_session_cache_misses' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of SSL session cache misses ')
       ,Option(var='Ssl_session_cache_mode' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The SSL session cache mode ')
       ,Option(var='Ssl_session_cache_overflows' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of SSL session cache overflows ')
       ,Option(var='Ssl_session_cache_size' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The SSL session cache size ')
       ,Option(var='Ssl_session_cache_timeouts' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of SSL session cache timeouts ')
       ,Option(var='Ssl_sessions_reused' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' How many SSL connections were reused from the cache ')
       ,Option(var='Ssl_used_session_cache_entries' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' How many SSL session cache entries were used ')
       ,Option(var='Ssl_verify_depth' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The verification depth for replication SSL connections ')
       ,Option(var='Ssl_verify_mode' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The verification mode for replication SSL connections ')
       ,Option(var='Ssl_version' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The SSL version number ')
       ,Option(var='Table_locks_immediate' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of times that a table lock was acquired immediately ')
       ,Option(var='Table_locks_waited' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of times that a table lock could not be acquired immediately and a wait was needed ')
       ,Option(var='Tc_log_max_pages_used' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' When the memory-mapped implementation of the log that is used by mysqld acts as the transaction coordinator for recovery of internal XA transactions,this variable indicates the largest number of pages used for the log since the server started ')
       ,Option(var='Tc_log_page_size' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The page size used for the memory-mapped implementation of the XA recovery log ')
       ,Option(var='Tc_log_page_waits' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' For the memory-mapped implementation of the recovery log, this variable increments each time the server was not able to commit a transaction and had to wait for a free page in the log ')
       ,Option(var='Threads_cached' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of threads in the thread cache ')
       ,Option(var='Threads_connected' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of currently open connections ')
       ,Option(var='Threads_created' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of threads created to handle connections ')
       ,Option(var='Threads_running' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of threads that are not sleeping ')
       ,Option(var='Uptime' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of seconds the server has been up ')
       ,Option(var='Uptime_since_flush_status' ,versions=((5, 0, 35), (5, 1, 23), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' The number of seconds since the most recent FLUSH STATUS ')
     ) # End of section Server
     ,'Merge' : (
        Option(var='Sort_merge_passes' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of merge passes that the sort algorithm has had to do ')
        ,     ) # End of section Merge
     ,'Innodb' : (
        Option(var='Com_show_innodb_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of SHOW INNODB STATUS statements ')
       ,Option(var='Com_show_ndb_status' ,versions=((4, 1), (5, 0), (5, 1), (6, 0)) ,description=' Count of SHOW NDB STATUS statements ')
       ,Option(var='Innodb_buffer_pool_pages_data' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pages containing data (dirty or clean) ')
       ,Option(var='Innodb_buffer_pool_pages_dirty' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pages currently dirty ')
       ,Option(var='Innodb_buffer_pool_pages_flushed' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of buffer pool page-flush requests ')
       ,Option(var='Innodb_buffer_pool_pages_free' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of buffer pool pages free ')
       ,Option(var='Innodb_buffer_pool_pages_latched' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of latched pages in InnoDB buffer pool ')
       ,Option(var='Innodb_buffer_pool_pages_misc' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pages that are busy because they have been allocated for administrative overhead ')
       ,Option(var='Innodb_buffer_pool_pages_total' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total size of the buffer pool, in pages ')
       ,Option(var='Innodb_buffer_pool_read_ahead' ,versions=((5, 1, 42), (5, 5)) ,description=' The number of pages read by the InnoDB read-ahead thread ')
       ,Option(var='Innodb_buffer_pool_read_ahead_evicted' ,versions=((5, 1, 42), (5, 5)) ,description=' The number of read-ahead pages evicted without being accessed ')
       ,Option(var='Innodb_buffer_pool_read_ahead_rnd' ,versions=((5, 0, 2), (5, 1), (5, 4), (6, 0)) ,description=' The number of random read-aheads initiated by InnoDB ')
       ,Option(var='Innodb_buffer_pool_read_ahead_seq' ,versions=((5, 0, 2), (5, 1), (5, 4), (6, 0)) ,description=' The number of sequential read-aheads initiated by InnoDB ')
       ,Option(var='Innodb_buffer_pool_read_requests' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of logical read requests InnoDB has done ')
       ,Option(var='Innodb_buffer_pool_reads' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of logical reads that InnoDB could not satisfy from the buffer pool and had to do a single-page read ')
       ,Option(var='Innodb_buffer_pool_wait_free' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Counts number of waits for pages to be flushed ')
       ,Option(var='Innodb_buffer_pool_write_requests' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of writes done to the buffer pool ')
       ,Option(var='Innodb_data_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of fsync() operations so far ')
       ,Option(var='Innodb_data_pending_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The current number of pending fsync() operations ')
       ,Option(var='Innodb_data_pending_reads' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The current number of pending reads ')
       ,Option(var='Innodb_data_pending_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pending writes ')
       ,Option(var='Innodb_data_read' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The amount of data read so far, in bytes ')
       ,Option(var='Innodb_data_reads' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total number of data reads ')
       ,Option(var='Innodb_data_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total number of data writes ')
       ,Option(var='Innodb_data_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The amount of data written in bytes ')
       ,Option(var='Innodb_dblwr_pages_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of doublewrite pages that have been written ')
       ,Option(var='Innodb_dblwr_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of doublewrite operations that have been performed ')
       ,Option(var='Innodb_have_atomic_builtins' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' Whether atomic instructions are available ')
       ,Option(var='Innodb_have_sync_atomic' ,versions=((5, 4),) ,description=' Whether atomic instructions are available ')
       ,Option(var='Innodb_heap_enabled' ,versions=((5, 4),) ,description=' Whether the InnoDB memory heap is enabled ')
       ,Option(var='Innodb_log_waits' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of times that the log buffer was too small and a wait was required for it to be flushed before continuing ')
       ,Option(var='Innodb_log_write_requests' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of log write requests ')
       ,Option(var='Innodb_log_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of physical writes to the log ')
       ,Option(var='Innodb_os_log_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of fsync() writes done to the log file ')
       ,Option(var='Innodb_os_log_pending_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pending log file fsync() operations ')
       ,Option(var='Innodb_os_log_pending_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pending log file writes ')
       ,Option(var='Innodb_os_log_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of bytes written to the log file ')
       ,Option(var='Innodb_page_size' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The compiled-in InnoDB page size ')
       ,Option(var='Innodb_pages_created' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pages created ')
       ,Option(var='Innodb_pages_read' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pages read ')
       ,Option(var='Innodb_pages_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of pages written ')
       ,Option(var='Innodb_row_lock_current_waits' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of row locks currently being waited for ')
       ,Option(var='Innodb_row_lock_time' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The total time spent in acquiring row locks, in milliseconds ')
       ,Option(var='Innodb_row_lock_time_avg' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The average time to acquire a row lock, in milliseconds ')
       ,Option(var='Innodb_row_lock_time_max' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum time to acquire a row lock, in milliseconds ')
       ,Option(var='Innodb_row_lock_waits' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of times a row lock had to be waited for ')
       ,Option(var='Innodb_rows_deleted' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of rows deleted from InnoDB tables ')
       ,Option(var='Innodb_rows_inserted' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of rows inserted into InnoDB tables ')
       ,Option(var='Innodb_rows_read' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of rows read from InnoDB tables ')
       ,Option(var='Innodb_rows_updated' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of rows updated in InnoDB tables ')
       ,Option(var='Innodb_wake_ups' ,versions=((5, 4),) ,description=' The number of wakeups that should not occur ')
     ) # End of section Innodb
   } # End of class status
 ,'system' : {
     'General' : (
        Option(var='engine_condition_pushdown' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Push supported query conditions to the storage engine ')
       ,Option(var='falcon_support_xa' ,versions=((6, 0, 4),) ,description=' Enables two-phase commit for Falcon tables ')
       ,Option(var='rand_seed1' ,versions=((4, 0, 5), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Used to support replication of the RAND() function ')
       ,Option(var='rand_seed2' ,versions=((4, 0, 5), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Used to support replication of the RAND() function ')
       ,Option(var='sync_master_info' ,versions=((5, 5), (6, 0, 11)) ,description=' Synchronize master.info to disk after every #th event. ')
       ,Option(var='sync_relay_log' ,versions=((5, 5), (6, 0, 10)) ,description=' Synchronize relay log to disk after every #th event. ')
       ,Option(var='sync_relay_log_info' ,versions=((5, 5), (6, 0, 11)) ,description=' Synchronize relay.info file to disk after every #th event. ')
       ,Option(var='transaction_allow_batching' ,versions=((5, 1, 23),) ,description=' Allows batching of statements within a transaction. ')
     ) # End of section General
     ,'Binlog' : (
        Option(var='binlog_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the cache to hold the SQL statements for the binary log during a transaction ')
       ,Option(var='binlog_format' ,versions=((5, 1, 5), (5, 4), (5, 5), (6, 0)) ,description=' Specifies the format of the binary log ')
       ,Option(var='max_binlog_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Can be used to restrict the total size used to cache a multi-transaction query ')
       ,Option(var='max_binlog_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Binary log will be rotated automatically when the size exceeds this value ')
     ) # End of section Binlog
     ,'Isam' : (
        Option(var='isam' ,versions=((4, 1),) ,description=' Obsolete. ISAM storage engine is no longer supported ')
       ,Option(var='skip-isam' ,versions=((4, 1, 1),) ,description=' Disable the ISAM storage engine ')
     ) # End of section Isam
     ,'Ssl' : (
        Option(var='have_openssl' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports SSL connections ')
       ,Option(var='have_ssl' ,versions=((5, 0, 38), (5, 1, 17), (5, 4), (6, 0)) ,description=' Whether mysqld supports SSL connections ')
       ,Option(var='ssl_ca' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' CA file in PEM format (check OpenSSL docs, implies --ssl) ')
       ,Option(var='ssl_capath' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' CA directory (check OpenSSL docs, implies --ssl) ')
       ,Option(var='ssl_cert' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' X509 cert in PEM format (implies --ssl) ')
       ,Option(var='ssl_cipher' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' SSL cipher to use (implies --ssl) ')
       ,Option(var='ssl_key' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' X509 key in PEM format (implies --ssl) ')
     ) # End of section Ssl
     ,'Bdb' : (
        Option(var='bdb-data-direct' ,versions=((5, 1, 4),) ,description=' bdb-data-direct ')
       ,Option(var='bdb-lock-detect' ,versions=((4, 1), (5, 0)) ,description=' Berkeley DB lock detect ')
       ,Option(var='bdb-log-direct' ,versions=((5, 1, 4),) ,description=' bdb-log-direct ')
       ,Option(var='bdb-shared-data' ,versions=((4, 1), (5, 0)) ,description=' Start Berkeley DB in multi-process mode ')
       ,Option(var='bdb-tmpdir' ,versions=((4, 1), (5, 0)) ,description=' Berkeley DB tempfile name ')
       ,Option(var='bdb_cache_size' ,versions=((4, 1), (5, 0)) ,description=' The buffer that is allocated to cache index and rows for BDB tables ')
       ,Option(var='bdb_home' ,versions=((4, 1), (5, 0)) ,description=' Berkeley DB home directory ')
       ,Option(var='bdb_log_buffer_size' ,versions=((4, 1), (5, 0)) ,description=' The buffer that is allocated to cache index and rows for BDB tables ')
       ,Option(var='bdb_logdir' ,versions=((4, 1), (5, 0)) ,description=' Berkeley DB log file directory ')
       ,Option(var='bdb_max_lock' ,versions=((4, 1), (5, 0)) ,description=' The maximum number of locks that can be active for a BDB table ')
       ,Option(var='have_bdb' ,versions=((4, 1), (5, 0)) ,description=' Is Berkeley DB supported ')
       ,Option(var='skip-sync-bdb-logs' ,versions=((4, 1), (5, 0)) ,description=' Disables synchronous BDB log flushes ')
       ,Option(var='sync_bdb_logs' ,versions=((4, 1), (5, 0)) ,description=' Synchronously flush Berkeley DB logs. Enabled by default ')
     ) # End of section Bdb
     ,'Ndb' : (
        Option(var='have_ndbcluster' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports NDB Cluster tables (set by --ndbcluster option) ')
       ,Option(var='ndb-wait-setup' ,versions=((5, 1, 39), (5, 1, 39), (5, 1, 39)) ,description=' Time (in seconds) for the MySQL server to wait for NDB engine setup to complete. ')
       ,Option(var='ndb_autoincrement_prefetch_sz' ,versions=((4, 1, 8), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' NDB auto-increment prefetch size ')
       ,Option(var='ndb_batch_size' ,versions=((5, 1, 23),) ,description=' The size (in bytes) to use for NDB transaction batches ')
       ,Option(var='ndb_cache_check_time' ,versions=((4, 1), (5, 0), (5, 1)) ,description=' The number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache ')
       ,Option(var='ndb_extra_logging' ,versions=((5, 1, 6),) ,description=' Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log ')
       ,Option(var='ndb_force_send' ,versions=((4, 1, 8), (5, 0), (5, 1)) ,description=' Forces sending of buffers to NDB immediately, without waiting for other threads ')
       ,Option(var='ndb_log_empty_epochs' ,versions=((5, 1, 31), (5, 1, 31)) ,description=' When used, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables even when --log-slave-updates is enabled. ')
       ,Option(var='ndb_log_orig' ,versions=((5, 1, 22),) ,description=' Log originating server id and epoch in mysql.ndb_binlog_index table. ')
       ,Option(var='ndb_log_update_as_write' ,versions=((5, 1, 19), (5, 1, 22)) ,description=' Toggles logging of updates on the master between updates (OFF) and writes (ON) ')
       ,Option(var='ndb_log_updated_only' ,versions=((5, 1, 19),) ,description=' Log complete rows (ON) or updates only (OFF) ')
       ,Option(var='ndb_optimization_delay' ,versions=((5, 1, 23),) ,description=' Sets the number of milliseconds to wait between processing sets of rows by OPTIMIZE TABLE on NDB tables. ')
       ,Option(var='ndb_table_no_logging' ,versions=((5, 1, 23),) ,description=' NDB tables are not checkpointed to disk (although table schema files are created) ')
       ,Option(var='ndb_table_temporary' ,versions=((5, 1, 23),) ,description=' NDB tables are not persistent on disk: no schema files are created and the tables are not logged ')
       ,Option(var='ndb_use_copying_alter_table' ,versions=((5, 1, 12),) ,description=' Use copying ALTER TABLE operations in MySQL Cluster ')
       ,Option(var='ndb_use_exact_count' ,versions=((4, 1, 8), (5, 0), (5, 1)) ,description=' Use exact row count when planning queries ')
       ,Option(var='ndb_use_transactions' ,versions=((4, 1, 18), (5, 0), (5, 1), (6, 0)) ,description=' Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query ')
       ,Option(var='ndb_wait_connected' ,versions=((5, 1, 16),) ,description=' Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections. ')
       ,Option(var='slave-allow-batching' ,versions=((5, 1, 19),) ,description=' Turns update batching on and off for a replication slave ')
     ) # End of section Ndb
     ,'Server' : (
        Option(var='auto_increment_increment' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' AUTO_INCREMENT columns are incremented by this value ')
       ,Option(var='auto_increment_offset' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Offset added to AUTO_INCREMENT columns ')
       ,Option(var='autocommit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Sets the autocommit mode ')
       ,Option(var='back_log' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of outstanding connection requests MySQL can have ')
       ,Option(var='backup_history_log' ,versions=((5, 6), (6, 0, 8)) ,description=' Enable or disable MySQL Backup history log ')
       ,Option(var='backup_history_log_file' ,versions=((5, 6), (6, 0, 8)) ,description=' Name of the MySQL Backup history log file ')
       ,Option(var='backup_progress_log' ,versions=((5, 6), (6, 0, 8)) ,description=' Enable or disable MySQL Backup progress log ')
       ,Option(var='backup_progress_log_file' ,versions=((5, 6), (6, 0, 8)) ,description=' Name of the MySQL Backup progress log file ')
       ,Option(var='backup_wait_timeout' ,versions=((6, 0, 7),) ,description=' Number of seconds DDL statements wait for BACKUP DATABASE or RESTORE before aborting ')
       ,Option(var='backupdir' ,versions=((5, 6), (6, 0, 7)) ,description=' Default backup image file directory ')
       ,Option(var='basedir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Path to installation directory ')
       ,Option(var='big_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Allow big result sets by saving all temporary sets on file ')
       ,Option(var='character_set' ,versions=((4, 1),) ,description=' The default character set ')
       ,Option(var='character_set_client' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Current client character set ')
       ,Option(var='character_set_connection' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Current connection character set ')
       ,Option(var='character_set_database' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The character set used by the default database ')
       ,Option(var='character_set_filesystem' ,versions=((5, 0, 19), (5, 1, 6), (5, 4), (5, 5), (6, 0)) ,description=' Set the file system character set ')
       ,Option(var='character_set_results' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Current result character set ')
       ,Option(var='character_set_server' ,versions=((4, 1, 3), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Set the default character set ')
       ,Option(var='character_set_system' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The character set used by the server for storing identifiers ')
       ,Option(var='character_sets_dir' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Directory where character sets are ')
       ,Option(var='collation_connection' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The collation of the connection ')
       ,Option(var='collation_database' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The collation used by the default database ')
       ,Option(var='collation_server' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Set the default collation ')
       ,Option(var='completion_type' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Default completion type ')
       ,Option(var='connect_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of seconds the mysqld server waits for a connect packet before responding with \'Bad handshake\' ')
       ,Option(var='datadir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Path to the database root ')
       ,Option(var='date_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The DATE format (For future) ')
       ,Option(var='datetime_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The DATETIME/TIMESTAMP format (for future) ')
       ,Option(var='debug' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Output debug log ')
       ,Option(var='debug_sync' ,versions=((5, 1, 41), (5, 5), (6, 0, 6)) ,description=' Interface to Debug Sync facility ')
       ,Option(var='default-collation' ,versions=((4, 1),) ,description=' Set the default collation ')
       ,Option(var='default_week_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The default week format used by WEEK() functions ')
       ,Option(var='delayed_insert_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing ')
       ,Option(var='delayed_insert_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating ')
       ,Option(var='delayed_queue_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' What size queue (in rows) should be allocated for handling INSERT DELAYED ')
       ,Option(var='div_precision_increment' ,versions=((5, 0, 6), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Scale of the result of \'/\' operator will be increased by this many digits ')
       ,Option(var='error_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of errors ')
       ,Option(var='event_scheduler' ,versions=((5, 1, 6), (5, 4), (5, 5), (6, 0)) ,description=' Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12 ')
       ,Option(var='expire_logs_days' ,versions=((4, 1, 0), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation ')
       ,Option(var='flush' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Flush tables to disk between SQL commands ')
       ,Option(var='flush_time' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' A dedicated thread is created to flush all tables at the given interval ')
       ,Option(var='ft_boolean_syntax' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE) ')
       ,Option(var='ft_max_word_len' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable ')
       ,Option(var='ft_min_word_len' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable ')
       ,Option(var='ft_query_expansion_limit' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of best matches to use for query expansion ')
       ,Option(var='ft_stopword_file' ,versions=((4, 1, 10), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Use stopwords from this file instead of built-in list ')
       ,Option(var='general_log' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=' Enable|disable general log ')
       ,Option(var='general_log_file' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=' Name of the general query log file ')
       ,Option(var='group_concat_max_len' ,versions=((4, 1, 10), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum length of the result of function group_concat ')
       ,Option(var='have_blackhole_engine' ,versions=((4, 1, 11), (5, 0), (5, 1)) ,description=' Whether mysqld supports BLACKHOLE tables ')
       ,Option(var='have_community_features' ,versions=((5, 1, 24), (5, 4)) ,description=' Whether statement profiling is enabled ')
       ,Option(var='have_compress' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Availability of the zlib compression library ')
       ,Option(var='have_crypt' ,versions=((4, 1, 10), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Availability of the crypt() system call ')
       ,Option(var='have_csv' ,versions=((4, 1, 14), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports csv tables ')
       ,Option(var='have_dynamic_loading' ,versions=((5, 1, 10), (5, 4), (6, 0)) ,description=' Whether mysqld supports dynamic loading of plugins ')
       ,Option(var='have_example_engine' ,versions=((4, 1, 14), (5, 0), (5, 1)) ,description=' Whether mysqld supports EXAMPLE tables ')
       ,Option(var='have_federated_engine' ,versions=((5, 0, 6), (5, 1)) ,description=' Whether mysqld supports FEDERATED tables ')
       ,Option(var='have_geometry' ,versions=((4, 1, 13), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports spatial data types ')
       ,Option(var='have_isam' ,versions=((4, 1), (5, 0), (5, 1)) ,description=' Whether mysqld supports isam tables ')
       ,Option(var='have_partition_engine' ,versions=((5, 1, 1),) ,description=' Whether mysqld supports partitioning ')
       ,Option(var='have_partitioning' ,versions=((5, 1, 6), (5, 4), (6, 0)) ,description=' Whether mysqld supports partitioning ')
       ,Option(var='have_profiling' ,versions=((5, 5), (6, 0, 14)) ,description=' Whether statement profiling is enabled ')
       ,Option(var='have_query_cache' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports query cache ')
       ,Option(var='have_raid' ,versions=((4, 1), (5, 0), (5, 1)) ,description=' Whether mysqld supports the raid option ')
       ,Option(var='have_symlink' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Is symbolic link support enabled ')
       ,Option(var='hostname' ,versions=((5, 0, 38), (5, 1, 17), (5, 4), (5, 5), (6, 0)) ,description=' The name of the server host ')
       ,Option(var='identity' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable is a synonym for the LAST_INSERT_ID variable. It exists for compatibility with other database systems ')
       ,Option(var='ignore_builtin_innodb' ,versions=((5, 1, 33), (5, 4), (5, 5)) ,description=' Ignore the built-in InnoDB (so that the InnoDB plugin can be used) ')
       ,Option(var='init_connect' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Statements that are executed for each new connection ')
       ,Option(var='init_file' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Read SQL commands from this file at startup ')
       ,Option(var='insert_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Set the value to be used by the following INSERT or ALTER TABLE statement when inserting an AUTO_INCREMENT value ')
       ,Option(var='interactive_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of seconds the server waits for activity on an interactive connection before closing it ')
       ,Option(var='join_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the buffer that is used for full joins ')
       ,Option(var='join_cache_level' ,versions=((6, 0, 9),) ,description=' How join buffers are used ')
       ,Option(var='keep_files_on_create' ,versions=((5, 0, 48), (5, 1, 21), (5, 4), (5, 5), (6, 0)) ,description=' Do not overwrite existing .MYD/.MYI files in default database directory ')
       ,Option(var='key_cache_age_threshold' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache ')
       ,Option(var='key_cache_block_size' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The default size of key cache blocks ')
       ,Option(var='key_cache_division_limit' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The minimum percentage of warm blocks in key cache ')
       ,Option(var='language' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Client error messages in given language. May be given as a full path ')
       ,Option(var='large_files_support' ,versions=((5, 0), (5, 1)) ,description=' Whether large files are supported ')
       ,Option(var='large_page_size' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of memory pages when large page support is enabled ')
       ,Option(var='large_pages' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enable support for large pages ')
       ,Option(var='last_insert_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The most recent AUTO_INCREMENT value ')
       ,Option(var='lc-messages' ,versions=((5, 5),) ,description=' The locale for error messages ')
       ,Option(var='lc-messages-dir' ,versions=((5, 5),) ,description=' The directory where error messages are located ')
       ,Option(var='lc_time_names' ,versions=((4, 1, 21), (5, 0, 25), (5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=' The locale that controls the language used to display day and month names ')
       ,Option(var='license' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Type of license for the server ')
       ,Option(var='locked_in_memory' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Lock the mysqld process in memory ')
       ,Option(var='locked_in_memory' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Whether mysqld is locked in memory ')
       ,Option(var='log' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Log connections and queries to file ')
       ,Option(var='log_backup_output' ,versions=((5, 6), (6, 0, 8)) ,description=' The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE ')
       ,Option(var='log_bin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enables binary log ')
       ,Option(var='log_bin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Whether the binary log is enabled ')
       ,Option(var='log_bin_trust_function_creators' ,versions=((5, 0, 16), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging ')
       ,Option(var='log_bin_trust_routine_creators' ,versions=((5, 0, 6), (5, 1), (5, 2), (5, 4)) ,description=' (deprecated) Use log-bin-trust-function-creators ')
       ,Option(var='log_error' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Error log file ')
       ,Option(var='log_output' ,versions=((5, 1, 6), (5, 4), (5, 5), (6, 0)) ,description=' The destination for general query log and slow query log output. Syntax: log-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE ')
       ,Option(var='log_queries_not_using_indexes' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Log queries that are executed without benefit of any index to the slow query log if it is open ')
       ,Option(var='log_slow_queries' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Whether or not to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options ')
       ,Option(var='log_warnings' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Log some noncritical warnings to the log file ')
       ,Option(var='long_query_time' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Log all queries that have taken more than long_query_time seconds to execute to file ')
       ,Option(var='low_priority_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' INSERT/DELETE/UPDATE has lower priority than selects ')
       ,Option(var='lower_case_file_system' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable describes the case sensitivity of file names on the file system ')
       ,Option(var='lower_case_table_names' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1 table names are stored in lowercase on disk and table names will be case-insensitive. Should be set to 2 if you are using a case insensitive file system ')
       ,Option(var='max_allowed_packet' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Max packetlength to send/receive from to server ')
       ,Option(var='max_connect_errors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If there is more than this number of interrupted connections from a host this host will be blocked from further connections ')
       ,Option(var='max_connections' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of simultaneous clients allowed ')
       ,Option(var='max_delayed_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Don\'t start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used ')
       ,Option(var='max_error_count' ,versions=((4, 1, 0), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Max number of errors/warnings to store for a statement ')
       ,Option(var='max_heap_table_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Don\'t allow creation of heap tables bigger than this ')
       ,Option(var='max_insert_delayed_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable is a synonym for max_delayed_threads ')
       ,Option(var='max_join_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Joins that are probably going to read more than max_join_size records return an error ')
       ,Option(var='max_length_for_sort_data' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Max number of bytes in sorted records ')
       ,Option(var='max_prepared_stmt_count' ,versions=((4, 1, 19), (5, 0, 21), (5, 1, 10), (5, 4), (5, 5), (6, 0)) ,description=' Maximum number of prepared statements in the server ')
       ,Option(var='max_relay_log_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If nonzero, relay log will be rotated automatically when the size exceeds this value ')
       ,Option(var='max_seeks_for_key' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Limit assumed max number of seeks when looking up rows based on a key ')
       ,Option(var='max_sort_length' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of bytes to use when sorting BLOB or TEXT values ')
       ,Option(var='max_sp_recursion_depth' ,versions=((5, 0, 17), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Maximum stored procedure recursion depth ')
       ,Option(var='max_tmp_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Maximum number of temporary tables a client can keep open at a time ')
       ,Option(var='max_user_connections' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum number of active connections for a single user (0 = no limit) ')
       ,Option(var='max_write_lock_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' After this many write locks, allow some read locks to run in between ')
       ,Option(var='min_examined_row_limit' ,versions=((5, 1, 21), (5, 4), (5, 5), (6, 0, 4)) ,description=' Queries examining fewer than this number of rows are not logged to slow query log ')
       ,Option(var='multi_range_count' ,versions=((5, 0, 3), (5, 1), (5, 2)) ,description=' The maximum number of ranges to send to a table handler at once during range selects ')
       ,Option(var='named_pipe' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Indicates whether the server supports connections over named pipes ')
       ,Option(var='net_buffer_length' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Buffer length for TCP/IP and socket communication ')
       ,Option(var='net_read_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of seconds to wait for more data from a connection before aborting the read ')
       ,Option(var='net_retry_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If a read on a communication port is interrupted, retry this many times before giving up ')
       ,Option(var='net_write_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of seconds to wait for a block to be written to a connection before aborting the write ')
       ,Option(var='old' ,versions=((5, 1, 18), (5, 4), (5, 5), (6, 0)) ,description=' Cause the server to revert to certain behaviors present in older versions ')
       ,Option(var='old_alter_table' ,versions=((5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Use old, nonoptimized alter table ')
       ,Option(var='open_files_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit() ')
       ,Option(var='optimizer_prune_level' ,versions=((5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space ')
       ,Option(var='optimizer_search_depth' ,versions=((5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Maximum depth of search performed by the query optimizer ')
       ,Option(var='optimizer_switch' ,versions=((5, 1, 34), (5, 2, 4), (5, 4, 2), (5, 5), (6, 0)) ,description=' Enable control over which optimizations to use ')
       ,Option(var='optimizer_use_mrr' ,versions=((5, 2, 4), (6, 0, 3)) ,description=' How the optimizer reads multiple ranges of index tuples ')
       ,Option(var='partition' ,versions=((5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enable (or disable) partitioning support ')
       ,Option(var='pid_file' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Process ID file used by mysqld_safe ')
       ,Option(var='plugin_dir' ,versions=((4, 1, 25), (5, 0, 67), (5, 1, 2), (5, 4), (5, 5), (6, 0)) ,description=' Directory for plugins ')
       ,Option(var='port' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Port number to use for connection ')
       ,Option(var='preload_buffer_size' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the buffer that is allocated when preloading indexes ')
       ,Option(var='prepared_stmt_count' ,versions=((4, 1, 19), (5, 0, 21), (5, 1, 10)) ,description=' The current number of prepared statements ')
       ,Option(var='profiling' ,versions=((5, 0, 37), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' Enable or disable statement profiling ')
       ,Option(var='profiling_history_size' ,versions=((5, 0, 37), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' How many statements to maintain profiling information for ')
       ,Option(var='protocol_version' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The version of the client/server protocol used by the MySQL server ')
       ,Option(var='pseudo_thread_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' For internal server use ')
       ,Option(var='query_alloc_block_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Allocation block size for query parsing and execution ')
       ,Option(var='query_cache_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Don\'t cache results that are bigger than this ')
       ,Option(var='query_cache_min_res_unit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data) ')
       ,Option(var='query_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The memory allocated to store results from old queries ')
       ,Option(var='query_cache_type' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Query cache type ')
       ,Option(var='query_cache_wlock_invalidate' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Invalidate queries in query cache on LOCK for write ')
       ,Option(var='query_prealloc_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Persistent buffer for query parsing and execution ')
       ,Option(var='range_alloc_block_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Allocation block size for storing ranges during optimization ')
       ,Option(var='read_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Each thread that does a sequential scan allocates a buffer of this size for each table it scans ')
       ,Option(var='read_only' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Make all nontemporary tables read-only ')
       ,Option(var='read_rnd_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' When reading rows in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer. ')
       ,Option(var='record_buffer' ,versions=() ,description=' Alias for read_buffer_size ')
       ,Option(var='relay_log_info_file' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The location and name of the file that remembers where the SQL replication thread is in the relay logs ')
       ,Option(var='relay_log_space_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Maximum space to use for all relay logs ')
       ,Option(var='server_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication. ')
       ,Option(var='shared_memory' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether the server allows shared-memory connections ')
       ,Option(var='shared_memory_base_name' ,versions=((4, 1, 0), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The name of shared memory to use for shared-memory connections ')
       ,Option(var='skip-external-locking' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Skip system (external) locking ')
       ,Option(var='skip_external_locking' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Use system (external) locking ')
       ,Option(var='slow_launch_time' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented ')
       ,Option(var='slow_query_log' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=' Enable|disable slow query log ')
       ,Option(var='slow_query_log_file' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=' Name of the slow query log file ')
       ,Option(var='socket' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Socket file to use for connection ')
       ,Option(var='sort_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Each thread that needs to do a sort allocates a buffer of this size ')
       ,Option(var='sql_auto_is_null' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1, you can find the last inserted row for a table that contains an AUTO_INCREMENT column by using the following construct: WHERE auto_increment_column IS NULL ')
       ,Option(var='sql_big_selects' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 0, MySQL aborts SELECT statements that are likely to take a very long time to execute ')
       ,Option(var='sql_big_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable is deprecated, and is mapped to big_tables ')
       ,Option(var='sql_buffer_result' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Forces the result to be put into a temporary table ')
       ,Option(var='sql_log_bin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Toggle binary logging ')
       ,Option(var='sql_log_off' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1, no logging is done to the general query log for this client ')
       ,Option(var='sql_log_update' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable is deprecated, and is mapped to SQL_LOG_BIN ')
       ,Option(var='sql_low_priority_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable is deprecated, and is mapped to low_priority_updates ')
       ,Option(var='sql_max_join_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable is deprecated, and is mapped to max_join_size ')
       ,Option(var='sql_mode' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Set the SQL server mode ')
       ,Option(var='sql_notes' ,versions=((4, 1, 11), (5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1, warnings of Note level are recorded ')
       ,Option(var='sql_quote_show_create' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1 the server quotes identifiers for SHOW CREATE TABLE and SHOW CREATE DATABASE statements ')
       ,Option(var='sql_safe_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1, MySQL aborts UPDATE or DELETE statements that do not use a key in the WHERE clause or a LIMIT clause ')
       ,Option(var='sql_select_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum number of rows to return from SELECT statements ')
       ,Option(var='sql_warnings' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This variable controls whether single-row INSERT statements produce an information string if warnings occur ')
       ,Option(var='storage_engine' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The default storage engine ')
       ,Option(var='sync_binlog' ,versions=((4, 1, 3), (5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Synchronously flush binary log to disk after every #th event ')
       ,Option(var='sync_frm' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Sync .frm to disk on create. Enabled by default ')
       ,Option(var='system_time_zone' ,versions=((4, 1, 3), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The server system time zone ')
       ,Option(var='table_cache' ,versions=((4, 1), (5, 0), (5, 1)) ,description=' The number of open tables for all threads ')
       ,Option(var='table_definition_cache' ,versions=((5, 1, 3), (5, 4), (6, 0)) ,description=' The number of table definitions that can be stored in the definition cache. ')
       ,Option(var='table_lock_wait_timeout' ,versions=((5, 0, 10), (5, 1), (5, 4), (6, 0)) ,description=' Currently unused ')
       ,Option(var='table_open_cache' ,versions=((5, 1, 3), (5, 4), (6, 0)) ,description=' The number of open tables for all threads ')
       ,Option(var='table_type' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 2), (5, 4)) ,description=' A synonym for storage_engine ')
       ,Option(var='thread_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' How many threads we should keep in a cache for reuse ')
       ,Option(var='thread_concurrency' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time ')
       ,Option(var='thread_handling' ,versions=((5, 1, 17), (5, 4), (6, 0)) ,description=' The thread-handling model ')
       ,Option(var='thread_pool_size' ,versions=((6, 0, 4),) ,description=' The size of the thread pool ')
       ,Option(var='thread_stack' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The stack size for each thread ')
       ,Option(var='time_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The TIME format (for future) ')
       ,Option(var='time_zone' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The current time zone. ')
       ,Option(var='timestamp' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Change the value returned by NOW() ')
       ,Option(var='tmpdir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Path for temporary files ')
       ,Option(var='transaction_alloc_block_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Allocation block size for transactions to be stored in binary log ')
       ,Option(var='transaction_prealloc_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Persistent buffer for transactions to be stored in binary log ')
       ,Option(var='tx_isolation' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The default transaction isolation level ')
       ,Option(var='updatable_views_with_limit' ,versions=((5, 0, 2), (5, 1), (5, 4), (6, 0)) ,description=' This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key ')
       ,Option(var='version' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Output version information and exit ')
       ,Option(var='version_comment' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' This variable contains the value of the --with-comment option specified when building MySQL ')
       ,Option(var='version_compile_machine' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The type of machine or architecture on which MySQL was built ')
       ,Option(var='version_compile_os' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The type of operating system on which MySQL was built ')
       ,Option(var='wait_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The number of seconds the server waits for activity on a connection before closing it ')
       ,Option(var='warning_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' The number of warnings ')
     ) # End of section Server
     ,'Replication' : (
        Option(var='have_row_based_replication' ,versions=((5, 1, 5),) ,description=' Shows whether row-based replication is supported ')
       ,Option(var='init_slave' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Command(s) that are executed when a slave connects to a master ')
       ,Option(var='log_slave_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' This option tells the slave to log the updates performed by its SQL thread to its own binary log ')
       ,Option(var='master-bind' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=' The network interface which is to be used for connecting to the master by a replication slave having multiple network connections ')
       ,Option(var='relay_log' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The location and base name to use for relay logs ')
       ,Option(var='relay_log_index' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The location and name to use for the file that keeps a list of the last relay logs ')
       ,Option(var='relay_log_purge' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Determines whether relay logs are purged ')
       ,Option(var='relay_log_recovery' ,versions=((5, 5), (6, 0, 11)) ,description=' Enables automatic recovery of relay log files from master at startup ')
       ,Option(var='report_host' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Host name or IP of the slave to be reported to the master during slave registration ')
       ,Option(var='report_password' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The account password that a slave server should report to the master server ')
       ,Option(var='report_port' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Port for connecting to slave reported to the master during slave registration ')
       ,Option(var='report_user' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The account name that a slave server should report to the master server ')
       ,Option(var='rpl_recovery_rank' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Not used ')
       ,Option(var='rpl_semi_sync_master_enabled' ,versions=((5, 5), (6, 0, 8)) ,description=' Whether semisynchronous replication is enabled on master ')
       ,Option(var='rpl_semi_sync_master_reply_log_file_pos' ,versions=((6, 0, 8),) ,description=' Internal use ')
       ,Option(var='rpl_semi_sync_master_timeout' ,versions=((5, 5), (6, 0, 8)) ,description=' Number of seconds to wait for slave acknowledgment ')
       ,Option(var='rpl_semi_sync_master_trace_level' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='rpl_semi_sync_master_wait_no_slave' ,versions=((5, 5), (6, 0, 14)) ,description=' Whether master waits for timeout even with no slaves ')
       ,Option(var='rpl_semi_sync_slave_enabled' ,versions=((5, 5), (6, 0, 8)) ,description=' Whether semisynchronous replication is enabled on slave ')
       ,Option(var='rpl_semi_sync_slave_trace_level' ,versions=((5, 5), (6, 0, 8)) ,description=' Internal use ')
       ,Option(var='slave_compressed_protocol' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Use compression on master/slave protocol ')
       ,Option(var='slave_exec_mode' ,versions=((5, 1, 23), (5, 1, 23), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' Allows for switching between idempotent mode (key and some other errors suppressed) and strict mode; strict mode is the default, except for MySQL Cluster, where idempotent is always used ')
       ,Option(var='slave_load_tmpdir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The location where the slave should put its temporary files when replicating a LOAD DATA INFILE command ')
       ,Option(var='slave_net_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of seconds to wait for more data from a master/slave connection before aborting the read ')
       ,Option(var='slave_skip_errors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Tells the slave thread to continue replication when a query returns an error from the provided list ')
       ,Option(var='slave_transaction_retries' ,versions=((4, 1, 11), (5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping ')
       ,Option(var='sql_slave_skip_counter' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The number of events from the master that a slave server should skip ')
     ) # End of section Replication
     ,'Innodb' : (
        Option(var='foreign_key_checks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' If set to 1 (the default), foreign key constraints for InnoDB tables are checked. ')
       ,Option(var='have_innodb' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports InnoDB tables ')
       ,Option(var='innodb_adaptive_flushing' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' Control InnoDB adaptive flushing of dirty pages ')
       ,Option(var='innodb_adaptive_hash_index' ,versions=((5, 0, 52), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=' Enable or disable InnoDB adaptive hash indexes ')
       ,Option(var='innodb_additional_mem_pool_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures ')
       ,Option(var='innodb_autoextend_increment' ,versions=((4, 1, 5), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Data file autoextend increment in megabytes ')
       ,Option(var='innodb_autoinc_lock_mode' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=' Set InnoDB auto-increment lock mode ')
       ,Option(var='innodb_buffer_pool_awe_mem_mb' ,versions=((4, 1, 0), (5, 0), (5, 1)) ,description=' If Windows AWE is used, the size in Megabytes of InnoDB buffer pool allocated from the AWE memory ')
       ,Option(var='innodb_buffer_pool_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the memory buffer InnoDB uses to cache data and indexes of its tables ')
       ,Option(var='innodb_change_buffering' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' Whether InnoDB performs insert buffering. ')
       ,Option(var='innodb_checksums' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enable InnoDB checksums validation ')
       ,Option(var='innodb_commit_concurrency' ,versions=((5, 0, 12), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Helps in performance tuning in heavily concurrent environments ')
       ,Option(var='innodb_concurrency_tickets' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket ')
       ,Option(var='innodb_data_file_path' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Path to individual files and their sizes ')
       ,Option(var='innodb_data_home_dir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The common part for InnoDB table spaces ')
       ,Option(var='innodb_doublewrite' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enable InnoDB doublewrite buffer ')
       ,Option(var='innodb_extra_dirty_writes' ,versions=((5, 4),) ,description=' Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent ')
       ,Option(var='innodb_fast_shutdown' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Speeds up the shutdown process of the InnoDB storage engine ')
       ,Option(var='innodb_file_format' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' The format for new InnoDB tables ')
       ,Option(var='innodb_file_format_check' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' Whether InnoDB performs file format compatibility checking ')
       ,Option(var='innodb_file_io_threads' ,versions=((4, 1), (5, 0), (5, 1), (6, 0)) ,description=' Number of file I/O threads in InnoDB ')
       ,Option(var='innodb_file_per_table' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Stores each InnoDB table to an .ibd file in the database dir ')
       ,Option(var='innodb_flush_log_at_trx_commit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second) ')
       ,Option(var='innodb_flush_method' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' With which method to flush data ')
       ,Option(var='innodb_force_recovery' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Helps to save your data in case the disk image of the database becomes corrupt ')
       ,Option(var='innodb_io_capacity' ,versions=((5, 1, 38), (5, 4), (5, 5)) ,description=' The limit on the maximum number of I/O operations per second ')
       ,Option(var='innodb_lock_wait_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Timeout in seconds an InnoDB transaction may wait for a lock before being rolled back ')
       ,Option(var='innodb_locks_unsafe_for_binlog' ,versions=((4, 1, 4), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Force InnoDB not to use next-key locking. Instead use only row-level locking ')
       ,Option(var='innodb_log_arch_dir' ,versions=((4, 1), (5, 0), (5, 1)) ,description=' Where full logs should be archived ')
       ,Option(var='innodb_log_archive' ,versions=((4, 1), (5, 0), (5, 1)) ,description=' Unused ')
       ,Option(var='innodb_log_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the buffer which InnoDB uses to write log to the log files on disk ')
       ,Option(var='innodb_log_file_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Size of each log file in a log group ')
       ,Option(var='innodb_log_files_in_group' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of InnoDB log files in the log group ')
       ,Option(var='innodb_log_group_home_dir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Path to InnoDB log files ')
       ,Option(var='innodb_max_dirty_pages_pct' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Percentage of dirty pages allowed in bufferpool ')
       ,Option(var='innodb_max_merged_io' ,versions=((5, 4),) ,description=' The maximum number of background I/O requests to merge to issue a larger I/O request ')
       ,Option(var='innodb_max_purge_lag' ,versions=((4, 1, 6), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Desired maximum length of the purge queue (0 = no limit) ')
       ,Option(var='innodb_mirrored_log_groups' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of identical copies of log groups we keep for the database ')
       ,Option(var='innodb_old_blocks_pct' ,versions=((5, 1, 41), (5, 5)) ,description=' Percentage of the InnoDB buffer pool to reserve for old blocks ')
       ,Option(var='innodb_old_blocks_time' ,versions=((5, 1, 41), (5, 5)) ,description=' How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end ')
       ,Option(var='innodb_open_files' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The maximum number of files that InnoDB keeps open at the same time ')
       ,Option(var='innodb_read_ahead_threshold' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' The sensitivity of InnoDB linear read-ahead ')
       ,Option(var='innodb_read_io_threads' ,versions=((5, 1, 38), (5, 4), (5, 5)) ,description=' The number of background I/O threads for read prefetch requests ')
       ,Option(var='innodb_replication_delay' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' The slave server replication thread delay ')
       ,Option(var='innodb_rollback_on_timeout' ,versions=((5, 0, 32), (5, 1, 15), (5, 4), (5, 5), (6, 0)) ,description=' Roll back entire transaction on transaction timeout, not just last statement ')
       ,Option(var='innodb_spin_wait_delay' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' The maximum delay between polls for a spin lock ')
       ,Option(var='innodb_stats_on_metadata' ,versions=((5, 1, 17), (5, 4), (5, 5), (6, 0)) ,description=' Enable or disable InnoDB table statistics updates for metadata statements ')
       ,Option(var='innodb_stats_sample_pages' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' The number of index pages to sample for index distribution statistics ')
       ,Option(var='innodb_strict_mode' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' Whether InnoDB returns errors rather than warnings for exceptional conditions ')
       ,Option(var='innodb_support_xa' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enable InnoDB support for the XA two-phase commit ')
       ,Option(var='innodb_sync_spin_loops' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Count of spin-loop rounds in InnoDB mutexes ')
       ,Option(var='innodb_table_locks' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Enable InnoDB locking in LOCK TABLES ')
       ,Option(var='innodb_thread_concurrency' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling ')
       ,Option(var='innodb_thread_concurrency_timer_based' ,versions=((5, 4),) ,description=' Whether to use the lock-free method of handling thread concurrency ')
       ,Option(var='innodb_thread_sleep_delay' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Time of innodb thread sleeping before joining InnoDB queue (usec). Value 0 disable a sleep ')
       ,Option(var='innodb_use_legacy_cardinality_algorithm' ,versions=((5, 0, 82), (5, 1, 35)) ,description=' Whether to use legacy InnoDB index cardinality calculation algorithm ')
       ,Option(var='innodb_use_sys_malloc' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' Whether InnoDB uses the OS or its own memory allocator ')
       ,Option(var='innodb_version' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=' The version of InnoDB ')
       ,Option(var='innodb_write_io_threads' ,versions=((5, 1, 38), (5, 4), (5, 5)) ,description=' The number of background I/O threads for writing dirty pages from the buffer cache to disk ')
       ,Option(var='timed_mutexes' ,versions=((5, 0, 3), (5, 1), (5, 4), (6, 0)) ,description=' Specify whether to time mutexes (only InnoDB mutexes are currently supported) ')
       ,Option(var='unique_checks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' If set to 1 (the default), uniqueness checks for secondary indexes in InnoDB tables are performed ')
     ) # End of section Innodb
     ,'Myisam' : (
        Option(var='bulk_insert_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Size of tree cache used in bulk insert optimization ')
       ,Option(var='concurrent_insert' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Use concurrent insert with MyISAM ')
       ,Option(var='delay_key_write' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Type of DELAY_KEY_WRITE ')
       ,Option(var='have_rtree_keys' ,versions=((4, 1, 3), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' YES if RTREE indexes are available, NO if not. (These are used for spatial indexes in MyISAM tables.) ')
       ,Option(var='key_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the buffer used for index blocks for MyISAM tables ')
       ,Option(var='myisam_data_pointer_size' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Default pointer size to be used for MyISAM tables ')
       ,Option(var='myisam_max_extra_sort_file_size' ,versions=((4, 1), (5, 0)) ,description=' Deprecated option ')
       ,Option(var='myisam_max_sort_file_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Don\'t use the fast sort index method to create index if the temporary file would get bigger than this ')
       ,Option(var='myisam_recover_options' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The value of the --myisam-recover option ')
       ,Option(var='myisam_repair_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair ')
       ,Option(var='myisam_sort_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The buffer that is allocated when sorting the index when doing a REPAIR or when creating indexes with CREATE INDEX or ALTER TABLE ')
       ,Option(var='myisam_stats_method' ,versions=((4, 1, 15), (5, 0, 14), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Specifies how MyISAM index statistics collection code should treat NULLs ')
       ,Option(var='myisam_use_mmap' ,versions=((5, 1, 4), (5, 4), (5, 5), (6, 0)) ,description=' Use memory mapping for reading and writing MyISAM tables ')
       ,Option(var='tmp_table_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table ')
     ) # End of section Myisam
     ,'Merge' : (
        Option(var='have_merge_engine' ,versions=((4, 1, 21), (5, 0, 24), (5, 1)) ,description=' Whether mysqld supports merge tables ')
        ,     ) # End of section Merge
     ,'Falcon' : (
        Option(var='falcon_checkpoint_schedule' ,versions=((6, 0, 2),) ,description=' Sets the frequency that in-memory structures are synchronized to disk ')
       ,Option(var='falcon_checksums' ,versions=((6, 0, 6),) ,description=' Enable Falcon checksum validation ')
       ,Option(var='falcon_consistent_read' ,versions=((6, 0, 4),) ,description=' Sets the repeatable read isolation mode ')
       ,Option(var='falcon_debug_mask' ,versions=((6, 0, 2),) ,description=' Sets the log information written to the standard output by the Falcon engine in the event of an error ')
       ,Option(var='falcon_debug_server' ,versions=((6, 0, 2),) ,description=' Specifies whether the debug server should be enabled. ')
       ,Option(var='falcon_disable_fsync' ,versions=((6, 0, 2),) ,description=' Disables the periodic fsync operation. ')
       ,Option(var='falcon_gopher_threads' ,versions=((6, 0, 4),) ,description=' Sets the number of gopher threads ')
       ,Option(var='falcon_index_chill_threshold' ,versions=((6, 0, 2),) ,description=' Number of megabytes of pending index data that should be stored until the data is flushed to the serial log ')
       ,Option(var='falcon_initial_allocation' ,versions=((6, 0, 2),) ,description=' Initial size of a Falcon tablespace file when created ')
       ,Option(var='falcon_io_threads' ,versions=((6, 0, 3),) ,description=' Number of asynchronous I/O threads ')
       ,Option(var='falcon_large_blob_threshold' ,versions=((6, 0, 4),) ,description=' Blobs smaller than this value are stored in data pages not blob pages ')
       ,Option(var='falcon_lock_wait_timeout' ,versions=((6, 0, 4),) ,description=' Number of seconds Falcon will force one transaction to wait on another ')
       ,Option(var='falcon_max_transaction_backlog' ,versions=((6, 0, 2),) ,description=' falcon_max_transaction_backlog ')
       ,Option(var='falcon_page_cache_size' ,versions=((6, 0, 2),) ,description=' Size of the memory cache (in bytes) for pages from the tablespace file ')
       ,Option(var='falcon_page_size' ,versions=((6, 0, 2),) ,description=' Size of the pages (in bytes) used to store information within the tablespace ')
       ,Option(var='falcon_record_chill_threshold' ,versions=((6, 0, 2),) ,description=' Number of megabytes of pending record data stored before flushing the records to the serial log ')
       ,Option(var='falcon_record_memory_max' ,versions=((6, 0, 2),) ,description=' Maximum amount of memory (in bytes) that will be allocated for caching record data ')
       ,Option(var='falcon_record_scavenge_floor' ,versions=((6, 0, 2),) ,description=' Percentage of falcon_record_scavenge_threshold that will be retained in the record cache after a scavenge ')
       ,Option(var='falcon_record_scavenge_threshold' ,versions=((6, 0, 2),) ,description=' Percentage of falcon_record_memory_max that will cause the scavenger thread to start removing old generations of records from the record cache ')
       ,Option(var='falcon_scavenge_schedule' ,versions=((6, 0, 2),) ,description=' Record scavenging threshold ')
       ,Option(var='falcon_serial_log_buffers' ,versions=((6, 0, 2),) ,description=' Memory windows (1MB each) allocated for the Falcon serial log ')
       ,Option(var='falcon_serial_log_dir' ,versions=((6, 0, 2),) ,description=' Location for the Falcon serial log files ')
       ,Option(var='falcon_serial_log_priority' ,versions=((6, 0, 4),) ,description=' Set the priority for writing the Falcon serial log ')
       ,Option(var='falcon_use_deferred_index_hash' ,versions=((6, 0, 4),) ,description=' Use a deferred index hash lookup ')
       ,Option(var='falcon_use_sectorcache' ,versions=((6, 0, 6),) ,description=' Use the sector cache for reading blocks from disk ')
       ,Option(var='falcon_use_supernodes' ,versions=((6, 0, 5),) ,description=' Use index supernodes ')
     ) # End of section Falcon
     ,'Security' : (
        Option(var='automatic_sp_privileges' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Creating and dropping stored procedures alters ACLs ')
       ,Option(var='local_infile' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Whether LOCAL is supported for LOAD DATA INFILE statements ')
       ,Option(var='old_passwords' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Use old password encryption method (needed for 4.0 and older clients) ')
       ,Option(var='safe_show_database' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Deprecated option; use GRANT SHOW DATABASES instead ')
       ,Option(var='secure_auth' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Disallow authentication for accounts that have old (pre-4.1) passwords ')
       ,Option(var='secure_backup_file_priv' ,versions=((5, 6), (6, 0), (6, 1, 11)) ,description=' Limit BACKUP DATABASE and RESTORE to files in a single directory ')
       ,Option(var='secure_file_priv' ,versions=((5, 0, 38), (5, 1, 17), (5, 4), (5, 5), (6, 0)) ,description=' Limit LOAD_FILE(), LOAD DATA, and SELECT ... INTO OUTFILE to files in a single directory ')
       ,Option(var='skip_networking' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Don\'t allow connection with TCP/IP ')
       ,Option(var='skip_show_database' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Don\'t allow \'SHOW DATABASE\' commands ')
     ) # End of section Security
     ,'Archive' : (
        Option(var='have_archive' ,versions=((4, 1, 13), (5, 0), (5, 1)) ,description=' Whether mysqld supports archive tables ')
        ,     ) # End of section Archive
     ,'Maria' : (
        Option(var='maria-block-size' ,versions=((6, 0, 6),) ,description=' Sets the block size for Maria tables ')
       ,Option(var='maria-checkpoint-interval' ,versions=((6, 0, 6),) ,description=' Sets the interval between automatic checkpoints ')
       ,Option(var='maria-log-file-size' ,versions=((6, 0, 6),) ,description=' Sets the size of each of the Maria log files ')
       ,Option(var='maria-log-purge-type' ,versions=((6, 0, 6),) ,description=' Sets the mode for purging Maria log files ')
       ,Option(var='maria-page-checksum' ,versions=((6, 0, 6),) ,description=' Sets the default mode for page checksums ')
       ,Option(var='maria-pagecache-age-threshold' ,versions=((6, 0, 6),) ,description=' Sets the pagecache age ')
       ,Option(var='maria-pagecache-buffer-size' ,versions=((6, 0, 6),) ,description=' Sets the buffer size for data and index pages ')
       ,Option(var='maria-pagecache-division-limit' ,versions=((6, 0, 6),) ,description=' The minimum percentage of warm blocks in the page cache ')
       ,Option(var='maria-recover' ,versions=((6, 0, 6),) ,description=' Force recovery of Maria tables without the log file ')
       ,Option(var='maria-repair-threads' ,versions=((6, 0, 6),) ,description=' Number of threads to be used when repairing tables ')
       ,Option(var='maria-sort-buffer-size' ,versions=((6, 0, 6),) ,description=' Sets the sort buffer size for indexes ')
       ,Option(var='maria-stats-method' ,versions=((6, 0, 6),) ,description=' Sets the statistics collection method ')
       ,Option(var='maria-sync-log-dir' ,versions=((6, 0, 6),) ,description=' Controls the synchronization of the directory after a log file has been extended or created ')
       ,Option(var='maria_max_sort_file_size' ,versions=((6, 0, 6),) ,description=' The maximum size of an external sort file ')
     ) # End of section Maria
   } # End of class system

} # End of 
