#ifndef _WB_OVERVIEW_PRIVILEGES_H_
#define _WB_OVERVIEW_PRIVILEGES_H_

#include "workbench/wb_overview.h"

namespace wb {
  
  class PhysicalOverviewBE;

  namespace internal {
  class PrivilegeContentListNode;

  class PrivilegeInfoNode : public OverviewBE::ContainerNode
  {
    PhysicalOverviewBE *_owner;

    bool add_new_user(WBContext *wb);
    bool add_new_role(WBContext *wb);
    
  public:
    PrivilegeInfoNode(const db_CatalogRef &catalog, PhysicalOverviewBE *owner);

    virtual void paste_object(WBContext *wb, bec::Clipboard *clip);
    virtual bool is_pasteable(bec::Clipboard *clip);

    virtual int get_popup_menu_items(WBContext *wb, bec::MenuItemList &items) { return 0; }
  };

}; };

#endif /* _WB_OVERVIEW_PRIVILEGES_H_ */
