/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#include "stdafx.h"

#include "Grt.h"
#include "GrtTemplates.h"
#include "sql_editor_wr.h"
#include "recordset_wr.h"


namespace MySQL {
namespace Grt {
namespace Db {
namespace Sql {


using namespace System;
using namespace System::Collections::Generic;


SqlEditorWrapper::SqlEditorWrapper(Ref ref)
  : _ref(ref)

{
}

SqlEditorWrapper::SqlEditorWrapper(IntPtr nref_ptr)
  : _ref(gcnew ManagedRef<::Sql_editor>(nref_ptr))
{
}

SqlEditorWrapper::~SqlEditorWrapper()
{
  if (!(void*)~_ref)
    return;
  reset_fe_callbacks();
  delete _ref;
}


void SqlEditorWrapper::reset_fe_callbacks()
{
  if ((void*)~_ref)
  {
    _ref->replace_selected_text_slot.clear();
    _ref->insert_text_slot.clear();
    _ref->current_statement_slot.clear();
    _ref->report_sql_statement_border.clear();
    _ref->sql_parser_err_cb(::Sql_parser_base::Parse_error_cb());
  }

  delete _replace_selected_text_delegate;
  _replace_selected_text_delegate= nullptr;

  delete _insert_text_delegate;
  _insert_text_delegate= nullptr;

  delete _current_statement_delegate;
  _current_statement_delegate= nullptr;

  delete on_report_sql_statement_border_delegate;
  on_report_sql_statement_border_delegate= nullptr;

  delete on_parse_err_delegate;
  on_parse_err_delegate= nullptr;

  delete on_eol_change_delegate;
  on_eol_change_delegate= nullptr;

  delete _change_selected_range_delegate;
  _change_selected_range_delegate = nullptr;

  delete _change_cursor_pos_delegate;
  _change_cursor_pos_delegate = nullptr;
}


int SqlEditorWrapper::int_option(String ^name)
{
  return _ref->int_option(NativeToCppString(name));
}


String ^ SqlEditorWrapper::string_option(String ^name)
{
  return CppStringToNative(_ref->string_option(NativeToCppString(name)));
}

//--------------------------------------------------------------------------------------------------

List<MySQL::Grt::MenuItem^>^ SqlEditorWrapper::get_context_menu()
{
  return CppVectorToObjectList<bec::MenuItem, MySQL::Grt::MenuItem>(_ref->get_context_menu());
}

//--------------------------------------------------------------------------------------------------

void SqlEditorWrapper::activate_context_menu_item(String^ action)
{
  _ref->activate_context_menu_item(NativeToCppString(action));
}

//--------------------------------------------------------------------------------------------------

void SqlEditorWrapper::get_sql_statement_border_by_line_pos(int lineno, int line_pos, int %stmt_begin_lineno, int %stmt_begin_line_pos, int %stmt_end_lineno, int %stmt_end_line_pos)
{
  ::Sql_editor::SqlStatementBorder sql_statement_border= _ref->get_sql_statement_border_by_line_pos(lineno, line_pos);
  stmt_begin_lineno= sql_statement_border.begin_lineno;
  stmt_begin_line_pos= sql_statement_border.begin_line_pos;
  stmt_end_lineno= sql_statement_border.end_lineno;
  stmt_end_line_pos= sql_statement_border.end_line_pos;
}


void SqlEditorWrapper::sql(String ^sql)
{
  _ref->sql(NativeToCppStringRaw(sql));
}


String ^ SqlEditorWrapper::sql()
{
  // must be handled in raw, with no conversion.. otherwise selection
  // ranges given by scintilla will not match the text because of newline size difference
  return CppStringToNativeRaw(_ref->sql());
}


String ^ SqlEditorWrapper::eol()
{
  const std::string &text= _ref->eol();
  return gcnew String(text.c_str(), 0, (int) text.size(), Encoding::UTF8);
}


void SqlEditorWrapper::eol_change_delegate(EolChangeDelegate::ManagedDelegate ^cb)
{
  on_eol_change_delegate= gcnew EolChangeDelegate(cb);
  _ref->eol_change_signal.connect(on_eol_change_delegate->get_slot());
}

String^ SqlEditorWrapper::get_keywords(KeywordList list)
{
  return CppStringToNativeRaw(_ref->get_keywords((Sql_editor::KeywordList) list));
};

String^ SqlEditorWrapper::get_function_names()
{
  return CppStringToNativeRaw(_ref->get_function_names());
};

};  // namespace Sql
};  // namespace Db
};  // namespace Grt
};  // namespace MySQL
