@echo off

if "%1"=="" goto printUsage
if "%2"=="" goto printUsage
if "%3"=="" goto printUsage

rem Set edition specific variables
if "%1"=="com-se" set BIN_DIR=..\..\bin\Release
if "%1"=="com-se" set LICENSE_TYPE=commercial
if "%1"=="com-se" set SETUP_TYPE=com-se
if "%1"=="com-se" set SETUP_TYPE_UC=SE

if "%1"=="gpl" set BIN_DIR=..\..\bin\Release_OSS
if "%1"=="gpl" set LICENSE_TYPE=gpl
if "%1"=="gpl" set SETUP_TYPE=gpl
if "%1"=="gpl" set SETUP_TYPE_UC=CE

rem Set version variables
set VERSION_MAIN=5.0
set VERSION_DETAIL=%2

if "%3"=="a" set BUILD_LEVEL=-alpha
if "%3"=="a" set BUILD_LEVEL_UC=Alpha
if "%3"=="b" set BUILD_LEVEL=-beta
if "%3"=="b" set BUILD_LEVEL_UC=Beta
if "%3"=="r" set BUILD_LEVEL=-rc
if "%3"=="r" set BUILD_LEVEL_UC=RC
if "%3"=="i" set BUILD_LEVEL=-internal

rem Set other variables
set DIST_DIR=.\distribution
set UTIL_PATH=..\..\..\mysql-gui-win-res\bin
set OUTPUT_FILENAME=mysql-workbench-%SETUP_TYPE%-%VERSION_DETAIL%%BUILD_LEVEL%-win32-noinstall.zip
set OUTPUT_DIRNAME="MySQL Workbench %VERSION_DETAIL% %SETUP_TYPE_UC%"
set TMP_DIR=.\temp

if not exist %BIN_DIR% goto ERROR
if not exist %DIST_DIR% mkdir %DIST_DIR%
if not exist %TMP_DIR% mkdir %TMP_DIR%


rem -------------------------------------------------------------------------------------
echo Copy Editions specific files...
echo .
if "%1"=="se" copy ..\..\LICENSE.mysql %BIN_DIR%\. 1> nul
if "%1"=="ce" copy ..\res\COPYING %BIN_DIR%\. 1> nul


rem -------------------------------------------------------------------------------------
echo Make Zip script started...
echo .

echo Copy files ...
if not exist %TMP_DIR%\%OUTPUT_DIRNAME% mkdir %TMP_DIR%\%OUTPUT_DIRNAME%
xcopy %BIN_DIR%\*.* %TMP_DIR%\%OUTPUT_DIRNAME%\. /S /Y /Q
echo .

rem -------------------------------------------------------------------------------------
echo Remove obsolete files ...
pushd %TMP_DIR%
pushd %OUTPUT_DIRNAME%
del /Q *.exp
del /Q *.lib
del /Q *.pdb
del /Q *vshost.exe
del /Q *vshost.exe.manifest
del /Q license.txt
rem for CE remove reporting dirs
if "%1"=="ce" rmdir /S /Q modules\data\wb_model_reporting
popd
popd
echo .


echo Build zip file...
pushd %TMP_DIR%
rem precompile Python sources
%PYTHON_EXE_PATH% -mcompileall %OUTPUT_DIRNAME%
..\%UTIL_PATH%\zip -9 -r %OUTPUT_FILENAME% %OUTPUT_DIRNAME%
popd
echo .

rem move generated file
move %TMP_DIR%\%OUTPUT_FILENAME% %DIST_DIR%\%OUTPUT_FILENAME%

rem remove temp dir
rmdir /S /Q %TMP_DIR%

pushd %DIST_DIR%
echo Make .md5 sum ...
..\%UTIL_PATH%\md5sum %OUTPUT_FILENAME% > %OUTPUT_FILENAME%.md5
popd
echo .


echo Build was successful. You can find the generated files in the %DIST_DIR% directory.

EXIT /B 0


:ERROR
echo Error: You have to provide a build in the %BIN_DIR% directory
EXIT /B 0

:ERROR2
echo Error: set_shell_vars.cmd cannot be generated
EXIT /B 0

:ERROR3
echo Error: The directory %SOURCE_DIR% has to contain the files from the .zip distribution
EXIT /B 0

:ERROR4
echo Error: Building the setup-files failed. Error messages should have been provided above.
EXIT /B 0

:printUsage
echo MakeZip Version 2.0.0
echo Usage:
echo .
echo %0 EDITION VERSION BUILD_LEVEL
echo .
echo   EDITION can be se or ce
echo   VERSION has to be a 3 number version code, starting with 5.0
echo   BUILD_LEVEL can be a (=alpha), b (=beta), r (=rc), g (=ga) , i (=internal)
echo .
echo   Examples:
echo   %0 ce 5.0.8 b
