/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _BASE_SQLSTRING_H_
#define _BASE_SQLSTRING_H_

#include <string>
#include <boost/cstdint.hpp>
#include "common.h"

namespace base {

  enum SqlStringFlags
  {
    QuoteOnlyIfNeeded = 1 << 0,
    UseAnsiQuotes     = 1 << 1
  };

  class BASELIBRARY_PUBLIC_FUNC sqlstring 
  {
    std::string _formatted;
    std::string _format_string_left;
    int _flags;

    std::string consume_until_next_escape();
    int next_escape();

    sqlstring& append(const std::string &s);
  public:
    static const sqlstring null;

    sqlstring();
    sqlstring(const char* format_string, int flags);
    sqlstring(const sqlstring &copy);
    bool done() const;

    operator  std::string ()const;

    //! replaces a ? in the format string with a long long/int64 numeric value
    sqlstring &operator <<(boost::int64_t);
    //! replaces a ? in the format string with a long numeric value
    sqlstring &operator <<(int);
    //! replaces a ? in the format string with a float numeric value
    sqlstring &operator <<(float val) { return operator<<((double)val); }
    //! replaces a ? in the format string with a double numeric value
    sqlstring &operator <<(double);
    //! replaces a ? in the format string with a quoted string value or ! with a back-quoted identifier value
    sqlstring &operator <<(const std::string&);
    //! replaces a ? in the format string with a quoted string value or ! with a back-quoted identifier value
    //! is the value is NULL, ? will be replaced with a NULL. ! will raise an exception
    sqlstring &operator <<(const char*);
    //! replaces a ? or ! with the content of the other string verbatim
    sqlstring &operator <<(const sqlstring&);
  };
};

#endif
