/* 
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

using System;
using System.Drawing;
using System.Windows.Forms;

using MySQL.Grt;

namespace MySQL.GUI.Workbench.Plugins
{
  public partial class PhysicalLayerEditor : ObjectEditorPlugin
  {
    #region Member Variables

    private MySQL.Grt.LayerEditorBE layerEditorBE { get { return Backend as MySQL.Grt.LayerEditorBE; } }

    #endregion

    #region Constructors

    protected PhysicalLayerEditor()
    {
      InitializeComponent();
    }

    public PhysicalLayerEditor(GrtManager GrtManager, GrtValue GrtObject)
      : base(new MySQL.Grt.LayerEditorBE(GrtManager, GrtObject))
    {
      InitializeComponent();

      // Init BE

      InitializingControls = true;
      try
      {
        RefreshFormData();
      }
      finally
      {
        InitializingControls = false;
      }

      layerEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);
    }

    #endregion

    #region ObjectEditorPlugin Overrides

    public override bool ChangeGrtList(GrtManager GrtManager, GrtValue GrtList)
    {
      InitializingControls = true;
      SuspendLayout();

      try
      {
        grtManager = GrtManager;
        grtList = GrtList;

        Backend = new MySQL.Grt.LayerEditorBE(GrtManager, GrtList);

        CallRefreshFormData();
      }
      finally
      {
        ResumeLayout();
        InitializingControls = false;
      }

      layerEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);

      Invalidate();

      return true;
    }

    #endregion

    #region Form implemenation

    protected override void RefreshFormData()
    {
      nameTextBox.Text = layerEditorBE.get_name();
      colorEdit.Text = layerEditorBE.get_color();

      TabText = nameTextBox.Text;
    }

    #endregion

    private void nameTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls && nameTextBox.Text != layerEditorBE.get_name())
      {
        layerEditorBE.set_name(nameTextBox.Text);
        TabText = nameTextBox.Text;
      }
    }

    private void colorDialogButton_Click(object sender, EventArgs e)
    {
      layerColorDialog.Color = ColorTranslator.FromHtml(layerEditorBE.get_color());
      if (layerColorDialog.ShowDialog() == DialogResult.OK)
      {
        Color newColor = layerColorDialog.Color;
        colorEdit.Text = ColorTranslator.ToHtml(newColor).ToLower();
        colorDialogButton.BackColor = layerColorDialog.Color;
      }
    }

    private void colorEdit_TextChanged(object sender, EventArgs e)
    {
      layerEditorBE.set_color(colorEdit.Text);
      try
      {
        colorDialogButton.BackColor = ColorTranslator.FromHtml(colorEdit.Text);
      }
      catch (Exception)
      {
        // Ignore exceptions. The color translator does not allow testing the given value first and
        // we want to give the user full control over the color.
      }
    }
  }
}