/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import "WBPluginEditorBase.h"
#include "grt/editor_base.h"
#import "MCPPUtilities.h"
#import "WBTabView.h"

#import "mforms/app.h"

@implementation WBPluginEditorBase

- (id)identifier
{
  return nil;
}


- (NSString*)title
{
  return nil;
}


- (NSImage*)titleIcon
{
  return nil;
}


- (NSView*)dockableView
{
  return nil;
}


- (void)setCompactMode:(BOOL)flag
{
  // no op by default if there's no compact/big modes supported
}

- (BOOL)enableLiveChangeButtons
{
  if (mApplyButton && mRevertButton)
  {
    [mApplyButton setHidden: NO];
    [mApplyButton setTarget: self];
    [mApplyButton setAction: @selector(applyLiveChanges:)];

    [mRevertButton setHidden: NO];
    [mRevertButton setTarget: self];
    [mRevertButton setAction: @selector(revertLiveChanges:)];
  }
  return NO;
}

- (void)reinitWithArguments:(const grt::BaseListRef&)args
{
}


- (void)updateTitle:(NSString*)title
{
  id superview = [[self dockableView] superview];
  if ([superview isKindOfClass: [NSTabView class]])
  {
    NSTabView *tabView= (NSTabView*)superview;
    // workaround for stupid tabview hack
    if ([[tabView superview] isKindOfClass: [WBTabView class]])
      tabView = (NSTabView*)[tabView superview];
    NSInteger index = [tabView indexOfTabViewItemWithIdentifier: [self identifier]];
    if (index != NSNotFound)
    {
      id item= [tabView tabViewItemAtIndex: index];
      [item setLabel: title];
    }
  }
}


- (void)setMinimumSize:(NSSize)size
{
  mMinumumSize= size;
}


- (void)refresh
{
}


- (NSSize)minimumSize
{
  return mMinumumSize;
}


- (BOOL)matchesIdentifierForClosingEditor:(NSString*)identifier
{
  return NO;
}

- (bec::BaseEditor*)editorBE
{
  return 0;
}

- (void)applyLiveChanges:(id)sender
{
  // set focus to nothing to force ongoing text changes to be commited
  [[[self dockableView] window] makeFirstResponder: nil];

  bec::BaseEditor *editor = [self editorBE];
  if (editor && editor->is_editing_live_object())
    editor->apply_changes_to_live_object();
}

- (void)revertLiveChanges:(id)sender
{
  bec::BaseEditor *editor = [self editorBE];
  if (editor && editor->is_editing_live_object())
    editor->refresh_live_object();
}


- (void)pluginDidShow:(id)sender
{
}

- (BOOL)pluginWillClose: (id)sender
{
  // set focus to nothing to force ongoing text changes to be commited
  [[[self dockableView] window] makeFirstResponder: nil];

  bec::BaseEditor *editor = [self editorBE];
  if (editor && !editor->can_close())
    return NO;
  
  // by default, we check if the firstResponder belongs to this plugin and make it
  // resign so that edits are commited
  id first= [[[self dockableView] window] firstResponder];
  id dockableView= [self dockableView];
  NSWindow *window= [[self dockableView] window];
  
  while (first && first != dockableView && first != window)
    first= [first superview];

  if (first != window)
    [first resignFirstResponder];
  
  return YES;
}

//--------------------------------------------------------------------------------------------------


static long send_editor(MScintillaView *editor, int msg, long param, long param2)
{
  return [editor getGeneralProperty: msg parameter: param extra: param2];
}
                        
/**
 * Helper method to simplify setup of code editors.
 *
 * TODO: make color and font settings customizable.
 * TODO: move this setup code to MSQLEditorController once all SQL editors derive from that.
 */
+ (void) setupCodeEditor: (MScintillaView*) editor backend: (Sql_editor::Ref) backend withStatus: (BOOL) withStatus
{
  // custom context menu disabled since all needed functionality is in MSQLEditorController
  // this should be replaced with that controller class, otherwise stuff like selection
  // doesn't get properly updated
  //[editor setEditorBackEnd: backend];
  //backend->replace_selected_text_slot= sigc::bind(sigc::ptr_fun(replace_selected_text), editor);

  [editor setStringProperty: SCI_STYLESETFONT parameter: STYLE_DEFAULT value: @"Andale Mono"];
  
  backend->setup_scintilla_editor(boost::bind(send_editor, editor, _1, _2, _3));

  // Other settings.
  // - Set up the normal selection background color.
  [editor setColorProperty: SCI_SETSELBACK parameter: 1 value: [NSColor selectedTextBackgroundColor]];
  
  InfoBar* infoBar = [[[InfoBar alloc] initWithFrame: NSMakeRect(0, 0, 400, 0)] autorelease];
  IBDisplay parts = IBDisplay(IBShowZoom | IBShowCaretPosition);
  if (withStatus)
    parts = IBShowAll;
  [infoBar setDisplay: parts];
  if (!withStatus)
    [infoBar sizeToFit];
  [editor setInfoBar: infoBar top: NO];
}

@end
