/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import <Cocoa/Cocoa.h>
#include "sqlide/sql_editor_be.h"
#import "WBBasePanel.h"

@class MScintillaView;
@class MTabSwitcher;
@class MSQLEditorController;
@class WBSQLQueryPanel;
@class MResultsetViewer;
@class WBSplitViewUnbrokenizerDelegate;
@class MVerticalLayoutView;

@interface WBQueryTab : WBBasePanel 
{
  IBOutlet NSView *mPanel;
  IBOutlet NSSplitView *mSplitView;
  IBOutlet MVerticalLayoutView *mEditorContainer;
  IBOutlet MScintillaView *mEditor;
  IBOutlet MTabSwitcher *mResultsTabSwitcher;
  IBOutlet NSTabView *mResultsTabView;
  IBOutlet WBSplitViewUnbrokenizerDelegate *mSplitViewDelegate;
  IBOutlet NSButton *mApplyButton;
  IBOutlet NSButton *mCancelButton;
  IBOutlet NSTextField *mInfoText;
  IBOutlet NSImageView *mInfoIcon;
  
  int mLastResultTabViewCount;
  float mSplitterPosition;
  BOOL mSplitterUpdatePending;
  BOOL mQueryCollapsed;
  WBSQLQueryPanel *mOwner;
  MSQLEditorController *mEditorController;
}

- (id)initWithOwner:(WBSQLQueryPanel*)owner
            backEnd: (Sql_editor::Ref)backend;

- (void)setQueryCollapsed: (BOOL)flag;
- (IBAction)activateQueryArea: (id)sender;

- (MScintillaView*)editorView;

- (MSQLEditorController*)editorController;

- (NSString*)string;
- (void)setString:(NSString*)string;
- (void)appendString:(NSString*)string;

- (MResultsetViewer*)selectedResultset;

- (void)showFindPanel:(MScintillaView*)editor;

- (void)updateResultsetTabs;
- (void)updateActiveRecordsetTitle;
- (void)removeRecordsetWithIdentifier:(id)identifier;

- (IBAction)actionButtonClicked:(id)sender;
@end
