//
//  WBModelSidebarController.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 15/Dec/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GRTTreeDataSource.h"
#import "MTableView.h"

namespace wb {
  class WBContextUI;
};

@class MCanvasViewer;
@class GRTTreeDataSource;
@class GRTListDataSource;


@interface WBModelSidebarController : NSObject<GRTDragDelegate>
{
  IBOutlet NSOutlineView *catalogOutline;
  IBOutlet NSTableView *userTypeTable;
  
  IBOutlet GRTTreeDataSource *catalogDS;  
  IBOutlet GRTListDataSource *userTypeDS;
  
  IBOutlet NSTableView *propertiesTable;
  
  IBOutlet MTableView *historyTable;
  IBOutlet GRTListDataSource *historyDS;
  
  wb::WBContextUI *_wbui;
  
  boost::signals2::connection _historyRefresh;
  boost::signals2::connection _userTypesRefresh;
}

- (IBAction)activateCatalogItem:(id)sender;
- (IBAction)activateHistoryItem:(id)sender;

- (void)setupWithWBContextUI:(wb::WBContextUI*)wbui;
- (void)reuseShareableDataSourcesFrom:(WBModelSidebarController*)sidebar;

- (void)updateForSelectionChange;
- (void)copyHistoryToPasteboard;

- (void)refresh;
- (void)refreshHistory;
- (void)refreshCatalogTree;
- (void)refreshUserTypeList;

- (void)invalidate;

// Access for backend callbacks.
- (NSOutlineView*) catalogOutline;
- (GRTTreeDataSource*) catalogDS;
- (NSTableView*) historyTable;
- (GRTListDataSource*) historyDS;
- (GRTListDataSource*) userTypeDS;
@end
