//
//  RoleEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 23/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#include "wb_config.h"

#import "WBPluginEditorBase.h"
#import "GRTListDataSource.h"

#include "grtdb/editor_user_role.h"

@class GRTTreeDataSource;
@class DbMysqlRoleEditor;

// Subclass of List data source to handle object drops
@interface RolePrivilegeObjectListDataSource : GRTListDataSource
{
  DbMysqlRoleEditor *mOwner;
  bec::RoleEditorBE *mBackEnd;
}

- (void)setRoleEditor:(DbMysqlRoleEditor*)owner;
- (void)setBackEnd:(bec::RoleEditorBE*)be;

@end


@interface RolePrivilegeListDataSource : GRTListDataSource
{
  DbMysqlRoleEditor *mOwner;
  bec::RolePrivilegeListBE *mList;
}

- (IBAction)uncheckAll:(id)sender;


- (void)setRoleEditor:(DbMysqlRoleEditor*)owner;
- (void)setListModel:(bec::RolePrivilegeListBE*)be;

@end


@interface DbMysqlRoleEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView;

  IBOutlet NSTextField *nameText;
  IBOutlet NSOutlineView *roleOutline;
  IBOutlet NSTableView *objectTable;
  IBOutlet NSTableView *privilegeTable;
  IBOutlet NSPopUpButton *parentPopUp;
  
  IBOutlet GRTTreeDataSource *roleTreeDS;
  IBOutlet RolePrivilegeObjectListDataSource *objectListDS;
  IBOutlet RolePrivilegeListDataSource *privilegeListDS;
  
  bec::RoleEditorBE *mBackEnd;
}

- (IBAction)selectedParent:(id)sender;

@end
